/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Component;
import java.awt.Rectangle;
import physicon.GraphEngine.GraphicEngine;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContainerBase;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.graphLib2.GraphLibData;

public class GraphContainer
extends GraphContainerBase {
    private GraphicEngine ge;
    private Component component;
    private Rectangle rect;

    public final void showElement(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfElement(graphElementInterface) == -1) {
            System.out.println("Warning!!! You are attempting");
            System.out.println("to show or hide the element");
            System.out.println("that is not in GraphContainer");
            return;
        }
        if (bl) {
            this.ge.RegisterGraphicObject(graphElementInterface.getGraphElement());
            return;
        }
        this.ge.RemoveGraphicObject(graphElementInterface.getGraphElement());
    }

    public GraphContainer(GraphContextBase graphContextBase, int n, Component component, int n2, int n3, int n4, int n5) {
        super(graphContextBase);
        this.component = component;
        this.rect = new Rectangle(n2, n3, n4, n5);
        this.ge = new GraphicEngine(1, n, GraphLibData.bgColor, component, n2, n3, n4, n5);
    }

    public GraphContainer(GraphContextBase graphContextBase, GraphicEngine graphicEngine, Component component) {
        super(graphContextBase);
        this.component = component;
        this.ge = graphicEngine;
    }

    public synchronized void startGE() {
        this.ge.Start();
    }

    public synchronized void stopGE() {
        this.ge.Stop();
    }

    public final void showScale(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfScale(graphElementInterface) == -1) {
            System.out.println("Warning!!! You are attempting");
            System.out.println("to show or hide the scale");
            System.out.println("that is not in GraphContainer");
            return;
        }
        if (bl) {
            this.ge.RegisterGraphicObject(graphElementInterface.getGraphElement());
            return;
        }
        this.ge.RemoveGraphicObject(graphElementInterface.getGraphElement());
    }

    public synchronized boolean contains(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.getContext();
        return this.rect.contains(graphContextBase.lp2gpX(doublePoint.x, doublePoint.y), graphContextBase.lp2gpY(doublePoint.x, doublePoint.y));
    }

    public Component getComponent() {
        return this.component;
    }

    public void invalidateAll() {
        super.invalidateAll();
        this.ge.Invalidate();
    }
}

