/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.CurveHatchingDrawer;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.DoubleRectangle;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementBase;
import physicon.graphLib2.LinearGraphContext;
import physicon.graphLib2.ParamCurve;
import physicon.graphLib2.Vect;

public class CurveHatching
extends GraphElementBase {
    private DoubleRectangle rect;
    public boolean side;
    private double angle;
    public double curveA;
    public double curveB = 1.0;
    public double curveC;

    public CurveHatching(CurveHatchingDrawer curveHatchingDrawer, ParamCurve paramCurve, DoubleRectangle doubleRectangle, DoublePoint doublePoint) {
        this(curveHatchingDrawer, paramCurve, doubleRectangle, doublePoint, 0.7853981633974483);
    }

    public CurveHatching(CurveHatchingDrawer curveHatchingDrawer, ParamCurve paramCurve, DoubleRectangle doubleRectangle, DoublePoint doublePoint, double d) {
        this(curveHatchingDrawer, paramCurve.getLocalPoint(paramCurve.getMinParamValue()), paramCurve.getLocalPoint(paramCurve.getMaxParamValue()), doubleRectangle, doublePoint, d);
    }

    public CurveHatching(CurveHatchingDrawer curveHatchingDrawer, DoublePoint doublePoint, DoublePoint doublePoint2, DoubleRectangle doubleRectangle, DoublePoint doublePoint3, double d) {
        super(curveHatchingDrawer);
        this.rect = doubleRectangle;
        if (d < 0.0) {
            d = 0.0;
        } else if (d > Math.PI) {
            d = Math.PI;
        }
        this.angle = d;
        if (doublePoint.x == doublePoint2.x) {
            this.curveA = 1.0;
            this.curveB = 0.0;
            this.curveC = doublePoint.x;
            this.side = doublePoint3.x > doublePoint.x;
            return;
        }
        this.curveA = (doublePoint2.y - doublePoint.y) / (doublePoint.x - doublePoint2.x);
        this.curveC = this.curveA * doublePoint.x + doublePoint.y;
        this.side = -this.curveA * doublePoint3.x + this.curveC > doublePoint3.y;
    }

    public DoubleRectangle getRoughRect() {
        if (this.getContainer() == null) {
            return new DoubleRectangle(0.0, 0.0, 0.0, 0.0);
        }
        GraphContextBase graphContextBase = this.getContext();
        graphContextBase.setOffset(graphContextBase.getZeroPoint());
        Rectangle rectangle = ((CurveHatchingDrawer)this.getDrawer()).getLocalRoughRect();
        return new DoubleRectangle(graphContextBase.gp2lp(new Point(rectangle.x, rectangle.y)), graphContextBase.gp2lp(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height)));
    }

    public void updateDrawer() {
        double d;
        double d2;
        super.updateDrawer();
        GraphContextBase graphContextBase = this.getContext();
        CurveHatchingDrawer curveHatchingDrawer = (CurveHatchingDrawer)this.getDrawer();
        double d3 = this.rect.x;
        double d4 = this.rect.y;
        double d5 = this.rect.width;
        double d6 = this.rect.height;
        double d7 = d6 / d5;
        if (Math.sin(this.angle) < 0.01) {
            d2 = 0.0;
            d = 1.0;
        } else if (Math.abs(Math.cos(this.angle)) < 0.01) {
            d2 = 1.0;
            d = 0.0;
        } else {
            d2 = Math.tan(this.angle);
            d2 = ((LinearGraphContext)graphContextBase).ll2glX(d2);
            d = -1.0;
            d = ((LinearGraphContext)graphContextBase).ll2glY(d);
        }
        Vect vect = new Vect(d, d2);
        Vect vect2 = this.angle > 1.5707963267948966 ? new Vect(d5, -d6) : new Vect(d5, d6);
        vect.scale(graphContextBase);
        vect2.scale(graphContextBase);
        double d8 = Vect.mult(vect, vect2);
        double d9 = Math.sqrt(1.0 - d8 * d8);
        double d10 = 12.0 / d9;
        d10 = ((LinearGraphContext)graphContextBase).gl2llX(d10 * vect2.x);
        double d11 = d3;
        while (d11 < d3 + d5) {
            Point point;
            Point point2;
            double d12;
            double d13;
            double d14;
            double d15;
            double d16 = d11;
            double d17 = d4 - (d16 - d3) * d7;
            if (this.angle > 1.5707963267948966) {
                d17 = -d17 + 2.0 * d4 - d6;
            }
            double d18 = d2 * d16 + d * d17;
            if (d2 == 0.0) {
                d15 = d3;
                d14 = d3 + d5;
                d12 = d13 = d17;
            } else if (d == 0.0) {
                d15 = d14 = d16;
                d12 = d4;
                d13 = d4 - d6;
            } else {
                d15 = (d18 - d * d4) / d2;
                if (d15 > d3 + d5) {
                    d15 = d3 + d5;
                }
                if (d15 < d3) {
                    d15 = d3;
                }
                d12 = (-d2 * d15 + d18) / d;
                d14 = (d18 - d * (d4 - d6)) / d2;
                if (d14 > d3 + d5) {
                    d14 = d3 + d5;
                }
                if (d14 < d3) {
                    d14 = d3;
                }
                d13 = (-d2 * d14 + d18) / d;
            }
            if (this.curveB != 0.0) {
                double d19 = -this.curveA * d15 + this.curveC;
                double d20 = -this.curveA * d14 + this.curveC;
                if (d19 < d12 ^ this.side || d20 < d13 ^ this.side) {
                    point2 = graphContextBase.lp2gp(new DoublePoint(d15, d12));
                    point = graphContextBase.lp2gp(new DoublePoint(d14, d13));
                    if (!(d19 < d12 ^ this.side) || !(d20 < d13 ^ this.side)) {
                        if (!(d19 < d12 ^ this.side)) {
                            point2 = graphContextBase.lp2gp(this.getCross(d2, d, d18));
                        }
                        if (!(d20 < d13 ^ this.side)) {
                            point = graphContextBase.lp2gp(this.getCross(d2, d, d18));
                        }
                    }
                    curveHatchingDrawer.addLine(point2, point);
                }
            } else if (d15 < this.curveC ^ this.side || d14 < this.curveC ^ this.side) {
                point2 = graphContextBase.lp2gp(new DoublePoint(d15, d12));
                point = graphContextBase.lp2gp(new DoublePoint(d14, d13));
                if (!(d15 < this.curveC ^ this.side) || !(d14 < this.curveC ^ this.side)) {
                    if (!(d15 < this.curveC ^ this.side)) {
                        point2 = graphContextBase.lp2gp(this.getCross(d2, d, d18));
                    }
                    if (!(d14 < this.curveC ^ this.side)) {
                        point = graphContextBase.lp2gp(this.getCross(d2, d, d18));
                    }
                }
                curveHatchingDrawer.addLine(point2, point);
            }
            d11 += d10;
        }
    }

    public final DoublePoint getCross(double d, double d2, double d3) {
        return CurveHatching.getCross(d, d2, d3, this.curveA, this.curveB, this.curveC);
    }

    static final DoublePoint getCross(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 * d4 - d6 * d) / (d4 * d2 - d * d5);
        double d8 = (d3 * d5 - d6 * d2) / (d5 * d - d2 * d4);
        return new DoublePoint(d8, d7);
    }

    public void setRect(DoubleRectangle doubleRectangle) {
        this.rect = doubleRectangle;
    }
}

