/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.GraphLibData;
import physicon.graphLib2.MarkerDrawerBase;

public class CircleMarkerDrawer
extends MarkerDrawerBase {
    private boolean filled;
    private int size;

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public CircleMarkerDrawer(Color color) {
        this(color, GraphLibData.bgColor, false, 3);
    }

    public CircleMarkerDrawer(Color color, Color color2) {
        this(color, color2, false, 3);
    }

    public CircleMarkerDrawer(Color color, boolean bl) {
        this(color, GraphLibData.bgColor, bl, 3);
    }

    public CircleMarkerDrawer(Color color, Color color2, boolean bl) {
        this(color, color2, bl, 3);
    }

    public CircleMarkerDrawer(Color color, Color color2, boolean bl, int n) {
        super(color, color2);
        this.filled = bl;
        this.size = n;
    }

    public void drawLocal(Graphics graphics) {
        Color color = graphics.getColor();
        if (!this.filled) {
            graphics.setColor(this.getBkgColor());
            graphics.fillOval(-this.size, -this.size, 2 * this.size, 2 * this.size);
            graphics.setColor(this.getColor());
            graphics.drawOval(-this.size, -this.size, 2 * this.size, 2 * this.size);
        } else {
            graphics.setColor(this.getColor());
            graphics.fillOval(-this.size, -this.size, 2 * this.size + 1, 2 * this.size + 1);
            graphics.drawOval(-this.size, -this.size, 2 * this.size, 2 * this.size);
        }
        graphics.setColor(color);
    }

    public Rectangle getLocalRoughRect() {
        int n = 4;
        return new Rectangle(-n, -n, 2 * n, 2 * n);
    }
}

