/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import physicon.graphLib2.ChartDrawerBase;
import physicon.graphLib2.DoubleRectangle;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementBase;

public class Chart
extends GraphElementBase {
    private double curValue;
    private double maxValue;
    private DoubleRectangle drect;

    public void setRectangle(DoubleRectangle doubleRectangle) {
        this.drect = doubleRectangle;
    }

    public Chart(ChartDrawerBase chartDrawerBase, DoubleRectangle doubleRectangle) {
        this(chartDrawerBase, doubleRectangle, 0.0, 0.0);
    }

    public Chart(ChartDrawerBase chartDrawerBase, DoubleRectangle doubleRectangle, double d, double d2) {
        super(chartDrawerBase);
        this.curValue = d;
        this.maxValue = d2;
        this.drect = doubleRectangle;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final double getCurValue() {
        return this.curValue;
    }

    public void setCurValue(double d) {
        this.curValue = d;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void updateDrawer() {
        super.updateDrawer();
        GraphContextBase graphContextBase = this.getContext();
        int n = graphContextBase.lp2gpX(this.drect.x, this.drect.y);
        int n2 = graphContextBase.lp2gpY(this.drect.x, this.drect.y);
        int n3 = graphContextBase.lp2gpX(this.drect.x + this.drect.width, this.drect.y + this.drect.height);
        int n4 = graphContextBase.lp2gpY(this.drect.x + this.drect.width, this.drect.y + this.drect.height);
        ChartDrawerBase chartDrawerBase = (ChartDrawerBase)this.getDrawer();
        chartDrawerBase.maxValue = this.maxValue;
        chartDrawerBase.curValue = this.curValue;
        chartDrawerBase.x = n;
        chartDrawerBase.y = n2;
        chartDrawerBase.width = n3 - n;
        chartDrawerBase.height = n4 - n2;
    }

    public final DoubleRectangle getRectangle() {
        return this.drect;
    }
}

