/*
 * Decompiled with CFR 0.152.
 */
package physicon.gas2d;

import java.awt.Rectangle;
import physicon.gas2d.GasContainer;
import physicon.gas2d.Molecule;

public class RectGasContainer
extends GasContainer {
    private Rectangle m_rect;

    public final synchronized void setRect(Rectangle rectangle) {
        this.m_rect = rectangle;
    }

    public RectGasContainer(Rectangle rectangle) {
        this.m_rect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(int n, int n2) {
        return this.m_rect.contains(n, n2);
    }

    public void interactWithWalls(Molecule molecule) {
        if (molecule.x < (float)this.m_rect.x) {
            molecule.x = this.m_rect.x;
            molecule.vx = Math.abs(molecule.vx);
        } else if (molecule.x >= (float)(this.m_rect.x + this.m_rect.width)) {
            molecule.x = this.m_rect.x + this.m_rect.width - 1;
            molecule.vx = -Math.abs(molecule.vx);
        }
        if (molecule.y < (float)this.m_rect.y) {
            molecule.y = this.m_rect.y;
            molecule.vy = Math.abs(molecule.vy);
            return;
        }
        if (molecule.y >= (float)(this.m_rect.y + this.m_rect.height)) {
            molecule.y = this.m_rect.y + this.m_rect.height - 1;
            molecule.vy = -Math.abs(molecule.vy);
        }
    }

    public Rectangle getRoughRect() {
        return this.m_rect;
    }

    public final Rectangle getRect() {
        return new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }
}

