/*
 * Decompiled with CFR 0.152.
 */
package physicon.gas2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import physicon.gas2d.Gas;
import physicon.gas2d.GasContainer;
import physicon.gas2d.Grid;
import physicon.gas2d.Molecule;

public class IdealGas
extends Gas {
    protected Molecule[] m_molecules;
    protected double m_speed;
    protected Color m_color;
    protected Grid m_grid;
    protected GasContainer m_container;
    protected int m_cellSize;

    public void reset() {
        int n = 0;
        while (n < this.m_molecules.length) {
            int n2;
            int n3;
            Molecule molecule = this.m_molecules[n];
            GasContainer gasContainer = this.getContainer();
            Rectangle rectangle = gasContainer.getRoughRect();
            while (!gasContainer.contains(n3 = (int)Math.round((double)rectangle.x + (double)rectangle.width * Math.random()), n2 = (int)Math.round((double)rectangle.y + (double)rectangle.height * Math.random()))) {
            }
            molecule.x = n3;
            molecule.y = n2;
            molecule.vx = (float)((Math.random() - 0.5) * 2.0 * this.m_speed);
            molecule.vy = (float)((Math.random() - 0.5) * 2.0 * this.m_speed);
            ++n;
        }
    }

    public IdealGas(GasContainer gasContainer, int n, Color color, double d, int n2) {
        super(gasContainer);
        this.m_container = gasContainer;
        this.m_color = color;
        this.m_speed = d;
        this.m_cellSize = n2;
        this.m_molecules = new Molecule[n];
        int n3 = 0;
        while (n3 < n) {
            this.m_molecules[n3] = new Molecule();
            ++n3;
        }
        this.m_grid = new Grid(gasContainer.getRoughRect(), n2);
        this.reset();
    }

    public IdealGas(GasContainer gasContainer, int n, Color color) {
        this(gasContainer, n, color, 2.0, 4);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.m_color);
        int n = 0;
        while (n < this.m_molecules.length) {
            Molecule molecule = this.m_molecules[n];
            graphics.fillRect(Math.round(molecule.x), Math.round(molecule.y), 2, 2);
            ++n;
        }
    }

    public void doStep() {
        int n = 0;
        while (n < this.m_molecules.length) {
            Molecule molecule = this.m_molecules[n];
            this.m_grid.setIndex(Math.round(molecule.x), Math.round(molecule.y), -1);
            molecule.x += molecule.vx;
            molecule.y += molecule.vy;
            this.getContainer().interactWithWalls(molecule);
            int n2 = Math.round(molecule.x);
            int n3 = Math.round(molecule.y);
            int n4 = this.m_grid.getIndex(n2, n3);
            if (n4 != -1) {
                Molecule molecule2 = this.m_molecules[n4];
                float f = molecule2.x - molecule.x;
                float f2 = molecule2.y - molecule.y;
                float f3 = f * (molecule.vx - molecule2.vx) + f2 * (molecule.vy - molecule2.vy);
                if (f3 > 0.0f) {
                    float f4 = f * f + f2 * f2;
                    float f5 = f3 * f / f4;
                    float f6 = f3 * f2 / f4;
                    molecule.vx -= f5;
                    molecule.vy -= f6;
                    molecule2.vx += f5;
                    molecule2.vy += f6;
                }
            }
            this.m_grid.setIndex(n2, n3, n);
            ++n;
        }
    }

    public void updateContainer() {
        this.m_grid.setRect(this.m_container.getRoughRect());
        int n = 0;
        while (n < this.m_molecules.length) {
            Molecule molecule = this.m_molecules[n];
            this.m_container.interactWithWalls(molecule);
            int n2 = Math.round(molecule.x);
            int n3 = Math.round(molecule.y);
            int n4 = this.m_grid.getIndex(n2, n3);
            if (n4 != -1) {
                Molecule molecule2 = this.m_molecules[n4];
                float f = molecule2.x - molecule.x;
                float f2 = molecule2.y - molecule.y;
                float f3 = f * (molecule.vx - molecule2.vx) + f2 * (molecule.vy - molecule2.vy);
                if (f3 > 0.0f) {
                    float f4 = f * f + f2 * f2;
                    float f5 = f3 * f / f4;
                    float f6 = f3 * f2 / f4;
                    molecule.vx -= f5;
                    molecule.vy -= f6;
                    molecule2.vx += f5;
                    molecule2.vy += f6;
                }
            }
            this.m_grid.setIndex(n2, n3, n);
            ++n;
        }
    }

    public Enumeration getMolecules() {
        return new Enumeration(){
            private int i;

            public Object nextElement() {
                return IdealGas.this.m_molecules[this.i++];
            }
            {
                IdealGas.this.getClass();
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.i < IdealGas.this.m_molecules.length;
            }
        };
    }

    public synchronized void setSpeed(double d) {
        double d2 = d / this.m_speed;
        this.m_speed = d;
        int n = 0;
        while (n < this.m_molecules.length) {
            this.m_molecules[n].vx = (float)((double)this.m_molecules[n].vx * d2);
            this.m_molecules[n].vy = (float)((double)this.m_molecules[n].vy * d2);
            ++n;
        }
    }
}

