/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ImageMagic {
    private static final Toolkit tk = Toolkit.getDefaultToolkit();
    private static Frame f;

    public static Image createImage(int n, int n2) {
        Image image;
        if (f == null) {
            ImageMagic.createFrame();
        }
        while ((image = f.createImage(n, n2)) == null) {
            ImageMagic.createFrame();
        }
        return image;
    }

    public static Image renderColors(Image image, Color color) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new RenderFilter(color));
        return tk.createImage(filteredImageSource);
    }

    public static Image replaceColor(Image image, Color color, int n) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new ReplaceFilter(color, n));
        return tk.createImage(filteredImageSource);
    }

    public static Image createDisabledImage(Image image, Color color) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new GrayFilter(true, 50, color));
        return tk.createImage(filteredImageSource);
    }

    public static Image removeColor(Image image, Color color) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new ReplaceFilter(color, 0xFFFFFF));
        return tk.createImage(filteredImageSource);
    }

    private static void createFrame() {
        f = new Frame();
        f.addNotify();
    }

    private static class RenderFilter
    extends RGBImageFilter {
        float red;
        float green;
        float blue;

        public int filterRGB(int n, int n2, int n3) {
            float f = (float)(n3 >> 16 & 0xFF) + (float)(n3 >> 8 & 0xFF) + (float)(n3 & 0xFF);
            int n4 = (int)Math.min(this.red * f, 255.0f);
            int n5 = (int)Math.min(this.green * f, 255.0f);
            int n6 = (int)Math.min(this.blue * f, 255.0f);
            return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6;
        }

        RenderFilter(Color color) {
            float f = color.getRed() + color.getGreen() + color.getBlue();
            this.red = (float)color.getRed() / f;
            this.green = (float)color.getGreen() / f;
            this.blue = (float)color.getBlue() / f;
            this.canFilterIndexColorModel = true;
        }
    }

    private static class ReplaceFilter
    extends RGBImageFilter {
        private int bkgRGB;
        private int replacement;

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this.bkgRGB) {
                return n3 & this.replacement;
            }
            return n3;
        }

        ReplaceFilter(Color color, int n) {
            this.bkgRGB = color.getRGB();
            this.replacement = n;
            this.canFilterIndexColorModel = true;
        }
    }

    private static class GrayFilter
    extends RGBImageFilter {
        private boolean brighter;
        private int percent;
        private Color bkgColor;

        public int filterRGB(int n, int n2, int n3) {
            if (this.bkgColor != null && n3 == this.bkgColor.getRGB()) {
                return n3;
            }
            int n4 = (int)((0.3 * (double)(n3 >> 16 & 0xFF) + 0.59 * (double)(n3 >> 8 & 0xFF) + 0.11 * (double)(n3 & 0xFF)) / 3.0);
            n4 = this.brighter ? 255 - (255 - n4) * (100 - this.percent) / 100 : n4 * (100 - this.percent) / 100;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            return n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4;
        }

        GrayFilter(boolean bl, int n, Color color) {
            this.brighter = bl;
            this.percent = n;
            this.bkgColor = color;
            this.canFilterIndexColorModel = true;
        }
    }
}

