/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.elfield;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import physicon.ap.elfield.CastShadow;
import physicon.ap.elfield.Charge;
import physicon.ap.elfield.Data;
import physicon.ap.elfield.DoubleVector;
import physicon.ap.elfield.Host;
import physicon.objava3.DecUtil;
import physicon.objava3.EventSubscriber;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;

class ApparatCanvas
extends SimWindow {
    SimWindow host;
    private CastShadow label;
    private Charge charge1;
    private Charge charge2;
    private boolean fl = true;
    private boolean pf = true;
    private int mode = 2;
    private int j;
    private final int center = 197;
    private final double coeff = 25.0;

    ApparatCanvas(SimWindow parent, Point refPoint, Dimension size) {
        super(parent, refPoint, size);
        new ReliefDecoration(this);
        this.host = parent;
        this.label = new CastShadow((SimObject)this, new Point(size.width / 2 - 3, size.height / 2 + 22), "d", "dShadow");
        this.charge1 = new Charge(this, new Point(197 - (int)Math.round(25.0 * Data.spinInit[2]), size.height / 2), Data.controlsEvt[1], "q1");
        this.charge1.setQ(Data.spinInit[0]);
        this.charge2 = new Charge(this, new Point(198 + (int)Math.round(25.0 * Data.spinInit[2]), size.height / 2), Data.controlsEvt[3], "q2");
        this.charge2.setQ(Data.spinInit[1]);
        this.j = 0;
        while (this.j < 3) {
            this.subscribe(Data.controlsEvt[this.j + 5], new EventSubscriber(){
                private final int number;
                {
                    this.number = ApparatCanvas.this.j;
                }

                public void receiveEvent(Object evt) {
                    ApparatCanvas.this.handleControls(evt, this.number);
                }
            });
            ++this.j;
        }
    }

    private void drawForceLines(Graphics g, int charge) {
        DoubleVector vect = new DoubleVector();
        double q1 = charge == 1 ? this.charge1.getQ() : this.charge2.getQ();
        Point p1 = charge == 1 ? this.charge1.getRefPoint() : this.charge2.getRefPoint();
        double q2 = charge == 1 ? this.charge2.getQ() : this.charge1.getQ();
        Point p2 = charge == 1 ? this.charge2.getRefPoint() : this.charge1.getRefPoint();
        Vector<Object> points = new Vector<Object>(100);
        if (Math.abs(q1) > 0.04) {
            double step = Math.abs(Data.spinStep[0] / q1 * Math.PI / 3.0);
            double angle = step / 2.0;
            while (angle < Math.PI) {
                int arrowBegin;
                vect.setAngle(angle, 5.0).setPoint(p1.x, p1.y);
                while (vect.x > 0.0 && vect.x < 390.0 && vect.y > 0.0 && vect.y < 260.0 && (this.mode == 1 || Math.abs(vect.x - (double)p2.x) + Math.abs(vect.y - (double)p2.y) > 5.0)) {
                    points.addElement(vect.clone());
                    vect.move();
                    vect = this.recalcVector(p1, q1, vect);
                    if (this.mode == 2) {
                        vect = DoubleVector.sum(vect, this.recalcVector(p2, q2, vect));
                    }
                    vect.norm();
                    if (!(q1 < 0.0)) continue;
                    vect.turn();
                }
                boolean twoEnds = Math.abs(vect.x - (double)p2.x) + Math.abs(vect.y - (double)p2.y) <= 5.0;
                int n = arrowBegin = q1 > 0.0 ? 9 : 7;
                if (twoEnds && charge == 1 && this.mode == 2) {
                    vect = (DoubleVector)points.elementAt(arrowBegin);
                    if (q1 < 0.0) {
                        vect.turn();
                    }
                    vect.drawPointer(g);
                    vect.drawPointerSym(g, p1.y);
                    vect = (DoubleVector)points.elementAt(points.size() - arrowBegin + 3 - (q1 > 0.0 ? 0 : 3));
                    if (q1 < 0.0) {
                        vect.turn();
                    }
                    vect.drawPointer(g);
                    vect.drawPointerSym(g, p1.y);
                    int tmp = points.size() - 2 * arrowBegin;
                    if (tmp > 37) {
                        vect = (DoubleVector)points.elementAt(arrowBegin + tmp / 3);
                        if (q1 < 0.0) {
                            vect.turn();
                        }
                        vect.drawPointer(g);
                        vect.drawPointerSym(g, p1.y);
                        vect = (DoubleVector)points.elementAt(points.size() - arrowBegin + 3 - tmp / 3);
                        if (q1 < 0.0) {
                            vect.turn();
                        }
                        vect.drawPointer(g);
                        vect.drawPointerSym(g, p1.y);
                    } else if (tmp > 17) {
                        vect = (DoubleVector)points.elementAt(arrowBegin + tmp / 2 + 2);
                        if (q1 < 0.0) {
                            vect.turn();
                        }
                        vect.drawPointer(g);
                        vect.drawPointerSym(g, p1.y);
                    }
                }
                if (charge != 2 || this.mode != 1 && !twoEnds) {
                    int i = 0;
                    while (i < points.size()) {
                        vect = (DoubleVector)points.elementAt(i);
                        vect.paint(g);
                        vect.paintSym(g, p1.y);
                        if (q1 < 0.0) {
                            vect.turn();
                        }
                        if (!twoEnds && i % 13 == arrowBegin) {
                            vect.drawPointer(g);
                            vect.drawPointerSym(g, p1.y);
                        }
                        ++i;
                    }
                    points.removeAllElements();
                }
                angle += step;
            }
        }
    }

    private void drawPotentField(Graphics g, int charge) {
        double q1 = charge == 1 ? this.charge1.getQ() : this.charge2.getQ();
        Point p1 = charge == 1 ? this.charge1.getRefPoint() : this.charge2.getRefPoint();
        double q2 = charge == 1 ? this.charge2.getQ() : this.charge1.getQ();
        Point p2 = charge == 1 ? this.charge2.getRefPoint() : this.charge1.getRefPoint();
        double koef = 5.0;
        if (Math.abs(q1) > 0.04) {
            double step = Math.abs(q1 * 0.07);
            double phy = Math.abs(q1 / koef);
            block0: while (phy >= 0.0) {
                DoubleVector vect;
                double angle;
                step *= 0.8;
                if (charge == 2) {
                    angle = charge == 1 ? Math.PI : 0.0;
                    vect = new DoubleVector();
                    vect.setAngle(angle, koef);
                    vect.setPoint(p1.x + (int)Math.round(Math.abs(0.5 * q1 * q1 / phy)) * (charge == 1 ? -1 : 1), p1.y);
                    while (angle >= 0.0 && angle <= Math.PI) {
                        vect.move();
                        vect = this.recalcVector(p1, q1, vect);
                        vect = DoubleVector.sum(vect, this.recalcVector(p2, q2, vect));
                        if (vect.x < (double)p2.x) break block0;
                        vect.perpNorm();
                        if (q1 < 0.0) {
                            vect.turn();
                        }
                        angle = Math.atan2((double)p1.y - vect.y, vect.x - (double)p1.x) * (double)(charge == 1 ? 1 : -1);
                    }
                }
                angle = charge == 1 ? Math.PI : 0.0;
                vect = new DoubleVector();
                vect.setAngle(angle, koef);
                vect.setPoint(p1.x + (int)Math.round(Math.abs(0.5 * q1 * q1 / phy)) * (charge == 1 ? -1 : 1), p1.y);
                while (angle >= 0.0 && angle <= Math.PI) {
                    vect.move();
                    vect = this.recalcVector(p1, q1, vect);
                    if (this.mode == 2) {
                        vect = DoubleVector.sum(vect, this.recalcVector(p2, q2, vect));
                    }
                    vect.perpNorm();
                    if (q1 < 0.0) {
                        vect.turn();
                    }
                    angle = Math.atan2((double)p1.y - vect.y, vect.x - (double)p1.x) * (double)(charge == 1 ? 1 : -1);
                    vect.paint(g);
                    vect.paintSym(g, p1.y);
                }
                phy -= step;
            }
        }
    }

    private void handleControls(Object value, int number) {
        switch (number) {
            case 0: {
                int y = this.charge1.getRefPoint().y;
                this.charge1.setRefPoint(197 - (int)Math.round(25.0 * (Double)value), y);
                this.charge2.setRefPoint(198 + (int)Math.round(25.0 * (Double)value), y);
                break;
            }
            case 1: {
                this.fl = (Boolean)value;
                break;
            }
            case 2: {
                this.pf = (Boolean)value;
            }
        }
        this.paintAll();
        this.flushBuffer();
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public void mouseDown(MouseEvent evt) {
        super.mouseDown(evt);
        this.updateOutput(evt.getX(), evt.getY());
    }

    public void mouseDrag(MouseEvent evt) {
        super.mouseDrag(evt);
        this.updateOutput(evt.getX(), evt.getY());
    }

    public void mouseUp(MouseEvent evt) {
        super.mouseUp(evt);
        this.updateOutput(-1, -1);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.mode == 2) {
            g.setColor(Color.white);
            Point p1 = this.charge1.getRefPoint();
            Point p2 = this.charge2.getRefPoint();
            g.drawLine(p1.x, p1.y, p1.x, p1.y + 42);
            g.drawLine(p2.x, p2.y, p2.x, p2.y + 43);
            p1.y += 40;
            p2.y += 40;
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            DecUtil.drawPointer(g, p1, p2, 9);
            DecUtil.drawPointer(g, p2, p1, 9);
        }
        if (this.pf) {
            g.setColor(Data.potentFieldColor);
            this.drawPotentField(g, 1);
            if (this.mode == 2) {
                this.drawPotentField(g, 2);
            }
        }
        if (this.fl) {
            g.setColor(Data.forceLineColor);
            this.drawForceLines(g, 1);
            if (this.mode == 2) {
                this.drawForceLines(g, 2);
            }
        }
    }

    private DoubleVector recalcVector(Point p, double q, DoubleVector v) {
        double x = v.x - (double)p.x;
        double y = v.y - (double)p.y;
        double r2 = x * x + y * y;
        double ang = Math.atan2(y, x);
        return new DoubleVector(v.vx, v.vy, v.x, v.y).setAngle(ang, 9.0E9 * q / r2);
    }

    void setMode(int i) {
        this.mode = i;
        this.charge2.setVisible(this.mode == 2);
        this.label.setVisible(this.mode == 2);
        int y = this.charge1.getRefPoint().y;
        switch (this.mode) {
            case 1: {
                this.charge1.setRefPoint(197, y);
                break;
            }
            case 2: {
                this.charge1.setRefPoint(395 - this.charge2.getRefPoint().x, y);
            }
        }
        this.paintAll();
        this.flushBuffer();
    }

    private void updateOutput(int x, int y) {
        double E = 0.0;
        double phy = 0.0;
        if (x >= 0 && y >= 0) {
            Point p1 = this.charge1.getRefPoint();
            Point p2 = this.charge2.getRefPoint();
            double q1 = this.charge1.getQ();
            double q2 = this.charge2.getQ();
            DoubleVector v1 = new DoubleVector(0.0, 0.0, x, y);
            v1 = DoubleVector.sum(this.recalcVector(p1, q1, v1), this.recalcVector(p2, q2, v1));
            E = v1.getLength() * 1.0E-11 * 42.0 * 42.0;
            phy = q1 / Math.sqrt((x - p1.x) * (x - p1.x) + (y - p1.y) * (y - p1.y));
            phy += q2 / Math.sqrt((x - p2.x) * (x - p2.x) + (y - p2.y) * (y - p2.y));
            phy *= 3.78;
        }
        ((Host)this.host).updateOutput(E, phy);
    }
}

