/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import physicon.controls.CUtil;
import physicon.controls.Image1x1;
import physicon.controls.mart.SButton;
import physicon.controls.mart.SliderCanvas;
import physicon.objava3.SequenceController;
import physicon.objava3.SimButton;
import physicon.objava3.SimConfig;
import physicon.objava3.SimSlider;
import physicon.objava3.SimWindow;
import physicon.objava3.physics.Spectrum;

public abstract class WaveLengthCanvas
extends SimWindow
implements SequenceController {
    private SimButton leftBtn;
    private SimButton rightBtn;
    SimSlider slider;
    SliderCanvas slc;
    private int bandHeight = 19;
    private Image m_pointerImageLower = new Image1x1("lwlpointer.gif");
    private int border = this.m_pointerImageLower.getWidth(this) / 2;

    public void onCreate() {
        super.onCreate();
        SliderCanvas sliderCanvas = (SliderCanvas)this.slider.getComponent().getComponent(0);
        this.slc.setMinShift(this.slc.getMinShift() + sliderCanvas.getMinShift());
        this.slc.setMaxShift(this.slc.getMaxShift() + sliderCanvas.getMaxShift());
    }

    public void setValue(double d) {
        this.slider.setValue(d);
        this.slc.setValue(d);
    }

    public double getValue() {
        return this.slider.getValue();
    }

    public double getMinValue() {
        return this.slider.getMinValue();
    }

    public WaveLengthCanvas(SimWindow simWindow, Point point, Dimension dimension, int n, int n2) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        Image1x1 image1x1 = new Image1x1("eleftbtn.gif");
        Dimension dimension2 = new Dimension(((Image)image1x1).getWidth(null), ((Image)image1x1).getHeight(null));
        this.slc = new SliderCanvas(380.0, 760.0, (double)n, (double)n2, 0){

            public void paint(Graphics graphics) {
                if (!WaveLengthCanvas.this.isCreated()) {
                    return;
                }
                WaveLengthCanvas.this.paintAll();
                WaveLengthCanvas.this.flushBuffer(graphics);
            }
            {
                WaveLengthCanvas.this.getClass();
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        this.slc.addActionListener(new ActionListener(){
            {
                WaveLengthCanvas.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getID() == -1) {
                    WaveLengthCanvas.this.setValue(WaveLengthCanvas.this.slc.getValue());
                    WaveLengthCanvas.this.notifyChange();
                    return;
                }
                WaveLengthCanvas.this.notifyLast();
            }
        });
        this.slc.addMouseListener(this);
        this.slc.setMinShift(dimension2.width);
        this.slc.setMaxShift(dimension2.width);
        this.slc.setBounds(0, 0, dimension.width, this.bandHeight);
        this.leftBtn = new SimButton(this, new Point(0, this.bandHeight), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("eleftbtn.gif"), new Image1x1("dleftbtn.gif"), new Image1x1("pleftbtn.gif"));
            }
            {
                WaveLengthCanvas.this.getClass();
            }

            public void notifyChange() {
                if (WaveLengthCanvas.this.getValue() <= WaveLengthCanvas.this.getMinValue()) {
                    return;
                }
                WaveLengthCanvas.this.setValue(WaveLengthCanvas.this.getValue() - WaveLengthCanvas.this.getStep());
                WaveLengthCanvas.this.notifyChange();
            }

            public void notifyLast() {
                WaveLengthCanvas.this.notifyLast();
            }
        };
        this.rightBtn = new SimButton(this, new Point(dimension.width - dimension2.width, this.bandHeight), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("erightbtn.gif"), new Image1x1("drightbtn.gif"), new Image1x1("prightbtn.gif"));
            }
            {
                WaveLengthCanvas.this.getClass();
            }

            public void notifyChange() {
                if (WaveLengthCanvas.this.getValue() >= WaveLengthCanvas.this.getMaxValue()) {
                    return;
                }
                WaveLengthCanvas.this.setValue(WaveLengthCanvas.this.getValue() + WaveLengthCanvas.this.getStep());
                WaveLengthCanvas.this.notifyChange();
            }

            public void notifyLast() {
                WaveLengthCanvas.this.notifyLast();
            }
        };
        this.slider = new SimSlider(this, new Point(dimension2.width, this.bandHeight), new Dimension(dimension.width - 2 * dimension2.width, dimension2.height), n, 380.0, 760.0, n2, 3, new String[0], null, null){
            {
                WaveLengthCanvas.this.getClass();
            }

            public void notifyChange() {
                WaveLengthCanvas.this.setValue(WaveLengthCanvas.this.slider.getValue());
                WaveLengthCanvas.this.notifyChange();
            }

            public void notifyLast() {
                WaveLengthCanvas.this.notifyLast();
            }
        };
        this.slider.setPaintTicks(false);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(SimConfig.bkgColor);
        graphics.fillRect(0, 0, this.getSize().width, this.bandHeight);
        Spectrum.drawHorz(graphics, new Rectangle(this.slc.getMinShift(), 0, this.slc.getRange(), this.bandHeight), true);
        this.getFactory().drawRelief(graphics, 0, 0, this.getSize().width, this.bandHeight, null, this);
        CUtil.drawImage(graphics, this.m_pointerImageLower, this.slc.getThumbPosition() - this.border, this.bandHeight - this.m_pointerImageLower.getHeight(this), null, this);
    }

    public abstract void notifyLast();

    public abstract void notifyChange();

    public double getMaxValue() {
        return this.slider.getMaxValue();
    }

    public double getStep() {
        return this.slider.getStep();
    }

    public void setStep(double d) {
        this.slider.setStep(d);
        this.slc.setStep(d);
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.slc);
        return panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.leftBtn.setEnabled(bl);
        this.rightBtn.setEnabled(bl);
    }
}

