/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import physicon.controls.CUtil;
import physicon.gas2d.IdealGas;
import physicon.gas2d.RectGasContainer;
import physicon.objava3.EventSubscriber;
import physicon.objava3.SimWindow;
import physicon.objava3.more.HotSpot;
import physicon.objava3.more.LinePointConvertor;

public class GasCilinder
extends SimWindow {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    static final int PISTON_THICKNESS = 17;
    static final int TOP_FIELD = 45;
    private IdealGas m_gas;
    RectGasContainer m_gasContainer;
    boolean m_pressureShown = false;
    boolean m_enableGas = false;
    private double m_minVolume;
    private double m_maxVolume;
    double m_currentVolume;
    double m_refPressure = 100.0;
    double m_currentPressure = 100.0;
    private double m_speed = 5.0;
    double m_secondPhaseVolume = 0.0;
    boolean m_showNailFlag = false;
    Font m_pressureFont = new Font("Serif", 2, 12);
    double m_quotient;
    private int orientation;
    private Piston piston;
    Color color;

    public int getOrientation() {
        return this.orientation;
    }

    private void setOrientation(int n) {
        this.orientation = n;
    }

    int getCilinderHeight() {
        if (this.getOrientation() == 0) {
            return this.getSize().width;
        }
        return this.getSize().height;
    }

    public void onCreate() {
        super.onCreate();
        this.setEnabled(true);
    }

    public void showNail(boolean bl) {
        this.m_showNailFlag = bl;
    }

    public GasCilinder(SimWindow simWindow, Point point, Dimension dimension) {
        this(simWindow, point, dimension, Color.cyan, 1);
    }

    public GasCilinder(SimWindow simWindow, Point point, Dimension dimension, Color color, int n) {
        this(simWindow, point, dimension, null, color, n);
    }

    public GasCilinder(SimWindow simWindow, Point point, Dimension dimension, String string) {
        this(simWindow, point, dimension, string, Color.cyan, 1);
    }

    public GasCilinder(SimWindow simWindow, Point point, Dimension dimension, String string, Color color, int n) {
        super(simWindow, point, dimension);
        this.setEnabled(false);
        this.setBkgColor(Color.black);
        this.setOrientation(n);
        this.color = color;
        this.piston = this.getOrientation() == 0 ? new HorizontalPiston(this, string) : new VerticalPiston(this, string);
        this.setMaxVolume(100.0);
        this.setMinVolume(0.0);
        this.m_gasContainer = new RectGasContainer(this.getContainerRectangle(this.m_maxVolume));
        this.m_gas = new IdealGas(this.m_gasContainer, 100, color, this.m_speed, 4);
        this.subscribe("evtTimer", new EventSubscriber(){

            public void receiveEvent(Object object) {
                if (GasCilinder.this.m_enableGas) {
                    GasCilinder.this.m_gasContainer.doStepGas();
                    GasCilinder.this.paintAll();
                    GasCilinder.this.flushBuffer();
                }
            }
            {
                GasCilinder.this.getClass();
            }
        });
        this.enableHotSpot(string != null);
        this.setVolume(80.0);
    }

    public void setPressure(double d) {
        this.m_currentPressure = d;
    }

    public void showPressure(boolean bl) {
        this.m_pressureShown = bl;
    }

    public void setRefPressure(double d) {
        this.m_refPressure = d;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_enableGas) {
            this.m_gasContainer.paintGas(graphics);
        }
        this.piston.draw(graphics);
    }

    public void enableGas(boolean bl) {
        this.m_enableGas = bl;
    }

    public void setMinVolume(double d) {
        this.m_minVolume = d;
        this.piston.setMinPosition(this.getCilinderHeight() - (int)Math.round(this.m_quotient * this.m_minVolume));
    }

    public synchronized void setVolume(double d) {
        this.m_currentVolume = d;
        if (d > this.m_maxVolume) {
            this.m_currentVolume = this.m_maxVolume;
        }
        if (d < this.m_minVolume) {
            this.m_currentVolume = this.m_minVolume;
        }
        this.piston.setPosition(this.getCilinderHeight() - (int)Math.round(this.m_quotient * this.m_currentVolume));
        Rectangle rectangle = this.getContainerRectangle(this.m_currentVolume);
        rectangle.height = rectangle.height - (this.getOrientation() == 0 ? (int)Math.round((double)this.getSize().height * this.m_secondPhaseVolume / this.m_currentVolume) : (int)Math.round(this.m_quotient * this.m_secondPhaseVolume));
        this.m_gasContainer.setRect(rectangle);
        this.getGasModel().updateContainer();
    }

    public void enableHotSpot(boolean bl) {
        this.piston.setVisible(bl);
    }

    public void resetGas() {
        this.getGasModel().reset();
    }

    public void setMaxVolume(double d) {
        this.m_maxVolume = d;
        this.m_quotient = (double)(this.getCilinderHeight() - 17 - 45) / this.m_maxVolume;
    }

    public void setSecondPhaseVolume(double d) {
        this.m_secondPhaseVolume = d;
        if (d >= this.m_maxVolume) {
            this.m_secondPhaseVolume = this.m_maxVolume;
        }
        Rectangle rectangle = this.getContainerRectangle(this.m_currentVolume);
        rectangle.height = rectangle.height - (this.getOrientation() == 0 ? (int)Math.round((double)this.getSize().height * this.m_secondPhaseVolume / this.m_currentVolume) : (int)Math.round(this.m_quotient * this.m_secondPhaseVolume));
        this.m_gasContainer.setRect(rectangle);
        this.getGasModel().updateContainer();
    }

    public void setSpeed(double d) {
        this.getGasModel().setSpeed(d * this.m_speed);
    }

    public IdealGas getGasModel() {
        return this.m_gas;
    }

    private void setGasModel(IdealGas idealGas) {
        this.m_gasContainer.setGas(idealGas);
        this.m_gas = idealGas;
    }

    private Rectangle getContainerRectangle(double d) {
        int n = (int)Math.round(this.m_quotient * d);
        if (this.getOrientation() == 0) {
            return new Rectangle(this.getSize().width - n, 0, n, this.getSize().height);
        }
        return new Rectangle(0, this.getSize().height - n, this.getSize().width, n);
    }

    class HorizontalPiston
    extends HotSpot
    implements EventSubscriber,
    Piston {
        private String eventName;

        public void receiveEvent(Object object) {
            double d = (double)(GasCilinder.this.getSize().width - ((Point)object).x) / GasCilinder.this.m_quotient;
            this.publishEvent(this.eventName, new Double(d));
        }

        public void draw(Graphics graphics) {
            int n;
            graphics.setColor(SystemColor.control);
            Rectangle rectangle = this.getRect();
            rectangle.translate(this.getRefPoint().x, this.getRefPoint().y);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            CUtil.drawStandardTwinRelief(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (GasCilinder.this.m_pressureShown) {
                n = (int)Math.round(10.0 * GasCilinder.this.m_currentPressure / GasCilinder.this.m_refPressure);
                int[] nArray = new int[]{rectangle.height / 2 - n, rectangle.height / 2 + n, rectangle.height / 2 + n, rectangle.height / 2 + n * 2, rectangle.height / 2, rectangle.height / 2 - n * 2, rectangle.height / 2 - n};
                int[] nArray2 = new int[]{rectangle.x - n * 3, rectangle.x - n * 3, rectangle.x - n * 2, rectangle.x - n * 2, rectangle.x, rectangle.x - n * 2, rectangle.x - n * 2};
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray2, nArray, 7);
                graphics.setColor(Color.green);
                graphics.drawPolygon(nArray2, nArray, 7);
                graphics.setColor(Color.black);
                graphics.setFont(GasCilinder.this.m_pressureFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n2 = fontMetrics.stringWidth("p");
                graphics.drawString("p", rectangle.x - (n + n2), (rectangle.height + fontMetrics.getAscent()) / 2);
            }
            n = (int)Math.round((double)GasCilinder.this.getSize().height * GasCilinder.this.m_secondPhaseVolume / GasCilinder.this.m_currentVolume);
            int n3 = (int)Math.round(GasCilinder.this.m_quotient * GasCilinder.this.m_currentVolume);
            graphics.setColor(GasCilinder.this.color);
            graphics.fillRect(GasCilinder.this.getCilinderHeight() - n3, rectangle.height - n, n3, n);
            if (GasCilinder.this.m_showNailFlag) {
                int n4 = GasCilinder.this.getCilinderHeight() - (int)Math.round(GasCilinder.this.m_quotient * GasCilinder.this.m_currentVolume) - 8 - 2;
                graphics.setColor(Color.black);
                graphics.drawLine(n4, 0, n4, 4);
                graphics.drawLine(n4 + 3, 0, n4 + 3, 4);
                graphics.drawLine(n4 - 1, 5, n4 + 4, 5);
                graphics.drawLine(n4 - 1, 6, n4 + 4, 6);
                graphics.drawLine(n4 - 1, 7, n4 + 4, 7);
                graphics.drawLine(n4, rectangle.height - 5, n4, rectangle.height - 1);
                graphics.drawLine(n4 + 3, rectangle.height - 5, n4 + 3, rectangle.height - 1);
                graphics.drawLine(n4 - 1, rectangle.height - 6, n4 + 4, rectangle.height - 6);
                graphics.drawLine(n4 - 1, rectangle.height - 7, n4 + 4, rectangle.height - 7);
                graphics.drawLine(n4 - 1, rectangle.height - 8, n4 + 4, rectangle.height - 8);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(n4 + 2, 0, n4 + 2, 4);
                graphics.drawLine(n4 + 2, rectangle.height - 5, n4 + 2, rectangle.height - 1);
                graphics.setColor(SystemColor.control);
                graphics.drawLine(n4 + 1, rectangle.height - 5, n4 + 1, rectangle.height - 1);
            }
        }

        HorizontalPiston(GasCilinder gasCilinder2, String string) {
            super(gasCilinder2, new Point(), new Rectangle(-17, -gasCilinder2.getSize().height / 2, 17, gasCilinder2.getSize().height), "PISTON HOT SPOT");
            GasCilinder.this.getClass();
            this.eventName = string;
            this.setPointConvertor(new LinePointConvertor(new Point(62, gasCilinder2.getSize().height / 2), new Point(0, gasCilinder2.getSize().height / 2)));
            if (string != null) {
                this.subscribe("PISTON HOT SPOT", this);
            }
        }

        public void setMinPosition(int n) {
            LinePointConvertor linePointConvertor = (LinePointConvertor)this.getPointConvertor();
            linePointConvertor.setSecondPoint(n, GasCilinder.this.getSize().height / 2);
        }

        public void setPosition(int n) {
            this.setRefPoint(n, GasCilinder.this.getSize().height / 2);
        }

        public void setMaxPosition(int n) {
            LinePointConvertor linePointConvertor = (LinePointConvertor)this.getPointConvertor();
            linePointConvertor.setFirstPoint(n, GasCilinder.this.getSize().height / 2);
        }
    }

    static interface Piston {
        public static final String HOTSPOT_EVENT_NAME = "PISTON HOT SPOT";

        public void draw(Graphics var1);

        public void setVisible(boolean var1);

        public void setMinPosition(int var1);

        public void setPosition(int var1);

        public void setMaxPosition(int var1);
    }

    class VerticalPiston
    extends HotSpot
    implements EventSubscriber,
    Piston {
        private String eventName;

        public void receiveEvent(Object object) {
            double d = (double)(GasCilinder.this.getSize().height - ((Point)object).y) / GasCilinder.this.m_quotient;
            this.publishEvent(this.eventName, new Double(d));
        }

        public void draw(Graphics graphics) {
            int n;
            graphics.setColor(SystemColor.control);
            Rectangle rectangle = this.getRect();
            rectangle.translate(this.getRefPoint().x, this.getRefPoint().y);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            CUtil.drawStandardTwinRelief(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (GasCilinder.this.m_pressureShown) {
                n = (int)Math.round(10.0 * GasCilinder.this.m_currentPressure / GasCilinder.this.m_refPressure);
                int[] nArray = new int[]{rectangle.width / 2 - n, rectangle.width / 2 + n, rectangle.width / 2 + n, rectangle.width / 2 + n * 2, rectangle.width / 2, rectangle.width / 2 - n * 2, rectangle.width / 2 - n};
                int[] nArray2 = new int[]{rectangle.y - n * 3, rectangle.y - n * 3, rectangle.y - n * 2, rectangle.y - n * 2, rectangle.y, rectangle.y - n * 2, rectangle.y - n * 2};
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, 7);
                graphics.setColor(Color.green);
                graphics.drawPolygon(nArray, nArray2, 7);
                graphics.setColor(Color.black);
                graphics.setFont(GasCilinder.this.m_pressureFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n2 = fontMetrics.stringWidth("p");
                graphics.drawString("p", (rectangle.width - n2) / 2, rectangle.y - n - 5);
            }
            n = (int)Math.round(GasCilinder.this.m_quotient * GasCilinder.this.m_secondPhaseVolume);
            graphics.setColor(GasCilinder.this.color);
            graphics.fillRect(rectangle.x, GasCilinder.this.getCilinderHeight() - n, rectangle.width, n);
            if (GasCilinder.this.m_showNailFlag) {
                int n3 = GasCilinder.this.getCilinderHeight() - (int)Math.round(GasCilinder.this.m_quotient * GasCilinder.this.m_currentVolume) - 8 - 2;
                graphics.setColor(Color.black);
                graphics.drawLine(0, n3, 4, n3);
                graphics.drawLine(0, n3 + 3, 4, n3 + 3);
                graphics.drawLine(5, n3 - 1, 5, n3 + 4);
                graphics.drawLine(6, n3 - 1, 6, n3 + 4);
                graphics.drawLine(7, n3 - 1, 7, n3 + 4);
                graphics.drawLine(rectangle.width - 5, n3, rectangle.width - 1, n3);
                graphics.drawLine(rectangle.width - 5, n3 + 3, rectangle.width - 1, n3 + 3);
                graphics.drawLine(rectangle.width - 6, n3 - 1, rectangle.width - 6, n3 + 4);
                graphics.drawLine(rectangle.width - 7, n3 - 1, rectangle.width - 7, n3 + 4);
                graphics.drawLine(rectangle.width - 8, n3 - 1, rectangle.width - 8, n3 + 4);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(0, n3 + 2, 4, n3 + 2);
                graphics.drawLine(rectangle.width - 5, n3 + 2, rectangle.width - 1, n3 + 2);
                graphics.setColor(SystemColor.control);
                graphics.drawLine(rectangle.width - 5, n3 + 1, rectangle.width - 1, n3 + 1);
            }
        }

        VerticalPiston(GasCilinder gasCilinder2, String string) {
            super(gasCilinder2, new Point(), new Rectangle(-gasCilinder2.getSize().width / 2, -17, gasCilinder2.getSize().width, 17), "PISTON HOT SPOT");
            GasCilinder.this.getClass();
            this.eventName = string;
            this.setPointConvertor(new LinePointConvertor(new Point(gasCilinder2.getSize().width / 2, 62), new Point(gasCilinder2.getSize().width / 2, 0)));
            if (string != null) {
                gasCilinder2.subscribe("PISTON HOT SPOT", this);
            }
        }

        public void setMinPosition(int n) {
            LinePointConvertor linePointConvertor = (LinePointConvertor)this.getPointConvertor();
            linePointConvertor.setSecondPoint(GasCilinder.this.getSize().width / 2, n);
        }

        public void setPosition(int n) {
            this.setRefPoint(GasCilinder.this.getSize().width / 2, n);
        }

        public void setMaxPosition(int n) {
            LinePointConvertor linePointConvertor = (LinePointConvertor)this.getPointConvertor();
            linePointConvertor.setFirstPoint(GasCilinder.this.getSize().width / 2, n);
        }
    }
}

