/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.objava3.DecUtil;
import physicon.objava3.SimObject;
import physicon.objava3.more.ColorDecorationBase;

public class LineDecoration
extends ColorDecorationBase {
    private Point endPoint;
    private int width;

    public LineDecoration(SimObject simObject, Point point, Point point2, Color color, int n) {
        super(simObject, point, color);
        this.endPoint = point2;
        this.width = n;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getColor());
        if (this.width > 1) {
            DecUtil.drawLine(graphics, 0, 0, this.endPoint.x, this.endPoint.y, this.width);
            return;
        }
        graphics.drawLine(0, 0, this.endPoint.x, this.endPoint.y);
    }

    public final Point getBeginPoint() {
        return this.getRefPoint();
    }

    public void setBeginPoint(Point point) {
        this.setRefPoint(point.x, point.y);
    }

    public Rectangle getRoughRect() {
        int n = this.getRefPoint().x;
        int n2 = this.getRefPoint().y;
        int n3 = Math.min(this.endPoint.x, n);
        int n4 = Math.max(this.endPoint.x, n);
        int n5 = Math.min(this.endPoint.y, n2);
        int n6 = Math.max(this.endPoint.y, n2);
        return new Rectangle(n3, n5, n4 - n3, n6 - n5);
    }

    public final Point getEndPoint() {
        return new Point(this.endPoint.x + this.getRefPoint().x, this.endPoint.y + this.getRefPoint().y);
    }

    public void setEndPoint(Point point) {
        this.endPoint = point;
        this.endPoint.translate(-this.getRefPoint().x, -this.getRefPoint().y);
    }
}

