/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import physicon.graphLib2.Chart;
import physicon.graphLib2.DoubleRectangle;
import physicon.graphLib2.LinHorChartDrawer;
import physicon.graphLib2.LinVertChartDrawer;
import physicon.graphLib2.LinearGraphContext;
import physicon.objava3.HostPanel;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindow;
import physicon.objava3.graph.SimGraphContainer;
import physicon.objava3.graph.SimGraphElement;
import physicon.objava3.more.ReliefDecoration;

public class SimEnergyChart
extends SimWindow {
    private SimGraphContainer container;
    private Chart potChart;
    private Chart kinChart;

    public double getMaxEnergy() {
        return this.potChart.getMaxValue();
    }

    public SimEnergyChart(HostPanel hostPanel, Point point, Dimension dimension, String string, String string2, int n) {
        this(hostPanel, point, dimension, string, string2, n, 10, true, Color.red, Color.blue, Color.gray);
    }

    public SimEnergyChart(HostPanel hostPanel, Point point, Dimension dimension, String string, String string2, int n, int n2, boolean bl) {
        this(hostPanel, point, dimension, string, string2, n, n2, bl, Color.red, Color.blue, Color.gray);
    }

    public SimEnergyChart(HostPanel hostPanel, Point point, Dimension dimension, String string, String string2, int n, int n2, boolean bl, Color color, Color color2, Color color3) {
        super(hostPanel, point, dimension);
        new ReliefDecoration(this);
        this.container = new SimGraphContainer(new LinearGraphContext(0, 0), this);
        this.container.getContext().scale(1.0, -1.0);
        if (bl) {
            this.potChart = new Chart(new LinHorChartDrawer(color, color3, n2, string), new DoubleRectangle(5.0, 5.0, dimension.width - 10 - n, (double)(dimension.height - 10) / 2.0));
            this.kinChart = new Chart(new LinHorChartDrawer(color2, color3, n2, string2), new DoubleRectangle(5.0, (double)dimension.height / 2.0, dimension.width - 10 - n, (double)(dimension.height - 10) / 2.0));
        } else {
            this.potChart = new Chart(new LinVertChartDrawer(color, color3, n2, string), new DoubleRectangle(5.0, dimension.height - 5, (double)(dimension.width - 10) / 2.0, -dimension.height + 10 + n));
            this.kinChart = new Chart(new LinVertChartDrawer(color2, color3, n2, string2), new DoubleRectangle((double)dimension.width / 2.0, dimension.height - 5, (double)(dimension.width - 10) / 2.0, -dimension.height + 10 + n));
        }
        this.container.addElement(new SimGraphElement((SimObject)this, this.potChart));
        this.container.addElement(new SimGraphElement((SimObject)this, this.kinChart));
    }

    public void setEnergy(double d, double d2) {
        this.potChart.setCurValue(d);
        this.kinChart.setCurValue(d2);
        this.potChart.setRedrawFlag(true);
        this.kinChart.setRedrawFlag(true);
        if (this.isCreated()) {
            this.paintAll();
            this.flushBuffer();
        }
    }

    public void setMaxEnergy(double d) {
        this.potChart.setMaxValue(d);
        this.kinChart.setMaxValue(d);
        this.potChart.setRedrawFlag(true);
        this.kinChart.setRedrawFlag(true);
        if (this.isCreated()) {
            this.paintAll();
            this.flushBuffer();
        }
    }
}

