/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import physicon.controls.ICheckbox;
import physicon.controls.IItem;
import physicon.objava3.Controller;
import physicon.objava3.SimCheckboxGroup;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimWindow;

public class SimCheckbox
extends SimWindow
implements ItemListener,
Controller {
    protected ICheckbox m_cb;
    private String m_eventName;
    private SimCheckboxGroup m_group;

    public void requestFocus() {
        this.m_cb.requestFocus();
    }

    public void setState(boolean bl) {
        this.m_cb.setState(bl);
    }

    public boolean getState() {
        return this.m_cb.getState();
    }

    public SimCheckbox(SimWindow simWindow, Point point, Dimension dimension, boolean bl, String string, String string2, SimCheckboxGroup simCheckboxGroup) {
        super(simWindow, point, dimension);
        this.m_eventName = string2;
        this.m_group = simCheckboxGroup;
        this.init(string, bl, simCheckboxGroup);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.notifyChange();
    }

    public void notifyChange() {
        if (this.m_eventName != null) {
            this.publishEvent(this.m_eventName, new Boolean(this.getState()));
        }
        if (this.m_group != null && this.m_group.m_eventName != null) {
            this.publishEvent(this.m_group.m_eventName, this);
        }
    }

    public void setStringValue(String string) {
        if ("true".equalsIgnoreCase(string)) {
            this.setState(true);
        } else if ("false".equalsIgnoreCase(string)) {
            this.setState(false);
        }
        this.notifyChange();
    }

    public String getStringValue() {
        if (this.getState()) {
            return "true";
        }
        return "false";
    }

    public void setCheckboxGroup(SimCheckboxGroup simCheckboxGroup) {
        this.m_group = simCheckboxGroup;
        this.m_cb.setCheckboxGroup(this.m_group);
    }

    public final SimCheckboxGroup getCheckboxGroup() {
        return this.m_group;
    }

    protected void init(String string, boolean bl, SimCheckboxGroup simCheckboxGroup) {
        this.m_cb = this.getFactory().createCheckbox(string, bl, simCheckboxGroup);
        this.m_cb.setBounds(0, 0, this.getSize().width, this.getSize().height);
        this.m_cb.addItemListener(this);
        this.m_cb.addMouseListener(this);
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.m_cb.getAWTComponent());
        return panel;
    }

    public void setEnabled(boolean bl) {
        this.m_cb.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setItemLabel(String string) {
        this.setItemLabel(string, 2);
    }

    public void setItemLabel(String string, int n) {
        SimMetaTeXBlock simMetaTeXBlock = new SimMetaTeXBlock(this.getParent(), new Point(), string, n, 0);
        simMetaTeXBlock.setVisible(false);
        this.m_cb.setItemLabel(simMetaTeXBlock);
    }

    public void setItemLabel(IItem iItem) {
        this.m_cb.setItemLabel(iItem);
    }

    public IItem getItemLabel() {
        return this.m_cb.getItemLabel();
    }

    public void setLabel(String string) {
        this.m_cb.setLabel(string);
    }

    public String getLabel() {
        return this.m_cb.getLabel();
    }

    public boolean isFocused() {
        return this.m_cb.isFocused();
    }
}

