/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.applet.Applet;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.util.Date;
import java.util.ResourceBundle;
import physicon.objava3.HostContainer;
import physicon.objava3.HostPanel;
import physicon.objava3.SimConfig;
import physicon.objava3.SimConstants;

public abstract class SimApplet
extends Applet
implements HostContainer {
    private HostPanel m_host;
    private boolean allowed = false;

    public void stop() {
        this.m_host.publishEvent("evtStop", null);
    }

    public void reset() {
        this.m_host.publishEvent("evtReset", null);
    }

    public final void setSkin(String string) {
        SimConfig.factory.setSkin(string);
        SimConfig.updateUI();
    }

    public String isEnabled(String string) {
        if (this.m_host.getControllable(string).isEnabled()) {
            return "true";
        }
        return "false";
    }

    public void setValue(String string, String string2) {
        this.m_host.getControllable(string).setStringValue(string2);
        this.m_host.paintAll();
        this.m_host.flushBuffer();
    }

    public String getValue(String string) {
        return this.m_host.getControllable(string).getStringValue();
    }

    public void destroy() {
        if (this.m_host != null) {
            this.m_host.destroy();
            this.remove(this.m_host.getComponent());
            this.m_host = null;
            System.gc();
        }
        super.destroy();
    }

    public void setVisible(String string, String string2) {
        boolean bl = Boolean.valueOf(string2);
        this.m_host.getControllable(string).setVisible(bl);
        this.m_host.paintAll();
        this.m_host.flushBuffer();
    }

    public HostPanel getHost() {
        return this.m_host;
    }

    public String isVisible(String string) {
        if (this.m_host.getControllable(string).isVisible()) {
            return "true";
        }
        return "false";
    }

    public final String getSkinName() {
        return SimConfig.factory.getSkinName();
    }

    public abstract HostPanel createHost();

    public void init() {
        int n = this.getCodeBase().getHost().hashCode();
        boolean bl = true;
        boolean bl2 = true;
        if (SimConstants.EXPIRATION_DATE != null) {
            bl2 = new Date().before(SimConstants.EXPIRATION_DATE);
        }
        this.allowed = bl2 && bl;
        this.setLayout(null);
        String string = this.getParameter("skin");
        if (string != null) {
            this.setSkin(string);
        }
        this.m_host = !this.allowed ? new HostPanel(this, this.getPreferredSize()){

            public void onCreate() {
                super.onCreate();
                this.getComponent().setLayout(new GridLayout(1, 1));
                ResourceBundle resourceBundle = ResourceBundle.getBundle("physicon.objava3.SimResources");
                String string = resourceBundle.getString("contactText");
                TextArea textArea = new TextArea(string, 0, 0, 3);
                textArea.setFont(new Font("TimesRoman", 1, 20));
                this.addComponent(textArea);
            }
            {
                SimApplet.this.getClass();
            }
        } : this.createHost();
        this.m_host.create();
        this.add(this.m_host.getComponent());
    }

    public void run() {
        this.m_host.publishEvent("evtRun", null);
    }

    public final void printState() {
        this.m_host.printState();
    }

    public void setEnabled(String string, String string2) {
        boolean bl = Boolean.valueOf(string2);
        this.m_host.getControllable(string).setEnabled(bl);
        this.m_host.paintAll();
        this.m_host.flushBuffer();
    }
}

