/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;

public class RootBlock
extends Block {
    private int h;
    private int wL;
    private int wR;
    private int wDgrExtra;
    private int hDgrExtra;

    public boolean testArgs(Vector vector) {
        return vector.size() > 0;
    }

    public RootBlock() {
        super(2);
    }

    public void setArgs(Vector vector) {
        if (vector.size() == 1) {
            this.blocks[0] = new Block();
            this.blocks[0].setProperties(this.props);
            this.blocks[1] = (Block)vector.elementAt(0);
            return;
        }
        super.setArgs(vector);
    }

    public void sizeSelf() {
        Block block = this.blocks[1];
        Block block2 = this.blocks[0];
        this.h = (int)((double)block.getHeight() * 1.2);
        this.wL = this.h / 3;
        this.wR = this.h / 8;
        this.width = block.width + this.wL + 2 + this.wR;
        int n = this.h;
        int n2 = this.h / 2;
        int n3 = 2 * this.wL / 3;
        if (block2.width > n3) {
            this.wDgrExtra = block2.width - n3;
        }
        if (block2.getHeight() > n2) {
            this.hDgrExtra = block2.getHeight() - n2;
        }
        this.ascent = n / 2;
        this.descent = n - this.ascent;
        this.width += this.wDgrExtra;
        n += this.hDgrExtra;
        this.ascent += this.hDgrExtra;
        this.coords[0].x = 0;
        this.coords[0].y = this.hDgrExtra + this.h / 2 - block2.getHeight();
        this.coords[1].x = this.wDgrExtra + this.wL + 2;
        this.coords[1].y = this.ascent - block.getAscent();
    }

    public int getArgType(int n) {
        if (n < 2) {
            return 1;
        }
        return -1;
    }

    public void paintSelf(Graphics graphics) {
        int n = this.wDgrExtra;
        int n2 = this.hDgrExtra;
        graphics.drawLine(n, n2 + this.h / 2, n + this.wL / 3, n2 + this.h / 2);
        graphics.drawLine(n + this.wL / 3, n2 + this.h / 2, n + 2 * this.wL / 3, n2 + this.h - 1);
        graphics.drawLine(n + 2 * this.wL / 3, n2 + this.h - 1, n + this.wL, n2);
        graphics.drawLine(n + this.wL, n2, n + this.blocks[1].width + this.wL + this.wR, n2);
    }

    protected void setChildrenScale(int n) {
        this.blocks[0].setScale(n - 1);
        this.blocks[1].setScale(n);
    }
}

