/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.CharCoder;
import physicon.metatex3.FontCache;
import physicon.metatex3.ImageCreator;
import physicon.metatex3.MetaTexProperties;
import physicon.metatex3.PixelGrabber;
import physicon.metatex3.ScriptsBlock;
import physicon.metatex3.TagParser;
import physicon.metatex3.TextBlock;
import physicon.objava3.SimConfig;

public class Parser
implements Cloneable {
    private String buf;
    private int len;
    private int pos;
    private int line;
    private int col;
    private Hashtable tags = new Hashtable();
    private MetaTexProperties props;
    private static ColorModel dcm = ColorModel.getRGBdefault();
    private static Color defaultColor = SimConfig.OUTPUT_FONT_COLOR;

    public Block parse(String string) throws ParseException {
        this.buf = CharCoder.toWin1251(string);
        this.len = this.buf.length();
        this.pos = 0;
        this.col = 1;
        this.line = 1;
        Block block = this.parse(-1);
        block.sizeSelf();
        block.setStart(0);
        block.setEnd(this.len);
        return block;
    }

    private Block parse(int n) throws ParseException {
        int n2 = this.pos;
        Vector<Block> vector = new Vector<Block>(1, 5);
        while (true) {
            int n3;
            if ((n3 = this.skip()) == n) {
                if (vector.size() != 1) {
                    Block block = new Block(vector.size());
                    block.setArgs(vector);
                    block.setProperties(this.props);
                    block.setStart(n2);
                    block.setEnd(this.pos);
                    return block;
                }
                return (Block)vector.elementAt(0);
            }
            if (n3 == 123) {
                this.next();
                vector.addElement(this.parse(125));
                this.next();
                continue;
            }
            if (n3 == 92) {
                vector.addElement(this.parseTag());
                continue;
            }
            if (n3 == 95 || n3 == 94) {
                ScriptsBlock scriptsBlock;
                Block block;
                int n4 = this.pos;
                boolean bl = n3 != 94;
                this.next();
                n3 = this.skip();
                if (n3 == 123) {
                    this.next();
                    block = this.parse(125);
                } else {
                    block = new TextBlock(this.props, (char)n3);
                }
                this.next();
                if (vector.size() > 0 && vector.elementAt(vector.size() - 1) instanceof ScriptsBlock) {
                    scriptsBlock = (ScriptsBlock)vector.elementAt(vector.size() - 1);
                } else {
                    scriptsBlock = new ScriptsBlock();
                    scriptsBlock.setProperties(this.props);
                    scriptsBlock.var = vector.size() > 0 ? (Block)vector.elementAt(vector.size() - 1) : new TextBlock(this.props, 0.0);
                    scriptsBlock.setStart(n4);
                    vector.addElement(scriptsBlock);
                }
                scriptsBlock.setEnd(this.pos);
                scriptsBlock.setScale(scriptsBlock.var.scale);
                if (!bl) {
                    scriptsBlock.addUpper(block);
                    continue;
                }
                scriptsBlock.addLower(block);
                continue;
            }
            if (n3 == -1) {
                throw new ParseException("end of input reached", this.pos);
            }
            TextBlock textBlock = new TextBlock(this.props, (char)n3);
            textBlock.setStart(this.pos);
            textBlock.setEnd(this.pos + 1);
            vector.addElement(textBlock);
            this.next();
        }
    }

    private Block parseTag() throws ParseException {
        Block block;
        int n = this.pos;
        int n2 = this.next();
        if (Character.isLetter((char)n2)) {
            Block block2;
            String string = new String();
            Vector<Object> vector = new Vector<Object>();
            while (Character.isLetter((char)n2)) {
                string = string + (char)n2;
                n2 = this.next();
            }
            try {
                block2 = this.getExternalBlock(string);
            }
            catch (Exception exception) {
                if (FontCache.testSymbol(this.props.getFont(0), string)) {
                    TextBlock textBlock = new TextBlock(this.props, string);
                    textBlock.setStart(n);
                    textBlock.setEnd(this.pos);
                    return textBlock;
                }
                try {
                    block2 = this.getNativeBlock(string);
                }
                catch (Exception exception2) {
                    throw new ParseException(exception2.getMessage(), this.pos);
                }
            }
            block2.setProperties(this.props);
            int n3 = 0;
            while ((n2 = this.skip()) == 123) {
                int n4 = block2.getArgType(n3);
                if (n4 == 0) {
                    String string2 = new String();
                    boolean bl = false;
                    n2 = this.next();
                    while (n2 != -1 && (bl || n2 != 125)) {
                        if (n2 == 92 && !bl) {
                            bl = true;
                        } else {
                            string2 = string2 + (char)n2;
                            bl = false;
                        }
                        n2 = this.next();
                    }
                    if (n2 == -1) {
                        throw new ParseException("unclosed param of tag \\" + string, this.pos);
                    }
                    vector.addElement(string2);
                } else if (n4 == 1) {
                    this.next();
                    vector.addElement(this.parse(125));
                } else {
                    throw new ParseException("bad params of tag \\" + string, this.pos);
                }
                this.next();
                ++n3;
            }
            if (!block2.testArgs(vector)) {
                throw new ParseException("bad params of tag \\" + string, this.pos);
            }
            block2.setStart(n);
            block2.setEnd(this.pos);
            block2.setArgs(vector);
            return block2;
        }
        if (n2 == 92 || n2 == 95 || n2 == 94 || n2 == 123 || n2 == 125) {
            block = new TextBlock(this.props, (char)n2);
        } else {
            String string = "" + (char)n2;
            try {
                block = this.getExternalBlock(string);
                block.setProperties(this.props);
            }
            catch (Exception exception) {
                throw new ParseException("unknown tag \\" + (char)n2, this.pos);
            }
        }
        this.next();
        block.setStart(n);
        block.setEnd(this.pos);
        return block;
    }

    public Parser() {
        this((String)null, (String)null);
    }

    public Parser(String string, String string2) {
        this.init(string, string2);
    }

    public Parser(Hashtable hashtable) {
        this.init(hashtable, null);
    }

    public Parser(Hashtable hashtable, String string) {
        this.init(hashtable, string);
    }

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public static Color getDefaultColor() {
        return defaultColor;
    }

    static String toString(int n) {
        String string = "";
        int n2 = 0;
        do {
            int n3 = n & 0xF;
            n >>>= 4;
            string = Character.forDigit(n3, 16) + string;
        } while (++n2 < 8);
        return string;
    }

    private int cur() {
        if (this.pos < this.len) {
            return this.buf.charAt(this.pos);
        }
        return -1;
    }

    private boolean eof() {
        return this.pos >= this.len;
    }

    private Block getNativeBlock(String string) throws Exception {
        if (Character.isUpperCase(string.charAt(0))) {
            throw new IllegalArgumentException("wrong name " + string + ". block names should start from lower case characters");
        }
        String string2 = "physicon.metatex3.";
        string2 = string2 + string.substring(0, 1).toUpperCase();
        string2 = string2 + string.substring(1);
        string2 = string2 + "Block";
        return (Block)Class.forName(string2).newInstance();
    }

    public static int[] grabImage(Image image, int n, int n2) {
        PixelGrabber pixelGrabber = new PixelGrabber(image);
        return pixelGrabber.getPixels();
    }

    private void registerParsers() {
        Vector vector = this.props.getParsers();
        int n = 0;
        while (n < vector.size()) {
            this.registerTagParser((String)vector.elementAt(n));
            ++n;
        }
    }

    private int next() {
        if (++this.pos < this.len) {
            char c = this.buf.charAt(this.pos);
            if (c == '\n') {
                this.col = 1;
                ++this.line;
            } else {
                this.col = c == '\t' ? (this.col += 8) : ++this.col;
            }
            return c;
        }
        this.pos = this.len;
        return -1;
    }

    public MetaTexProperties getProperties() {
        return this.props;
    }

    public Image createBlockImage(Block block) {
        return Parser.createBlockImage(block, this.props.isTransparent());
    }

    private static Image createBlockImage(Block block, boolean bl) {
        int n;
        int n2;
        int n3;
        Dimension dimension = block.getSize();
        Image image = ImageCreator.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        Color color = block.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(defaultColor);
        int[] nArray = Parser.grabImage(image, 1, 1);
        block.paint(graphics);
        graphics.dispose();
        if (!bl) {
            return image;
        }
        int n4 = n3 = 1;
        while (n4 < nArray.length) {
            n2 = 1;
            n = 0;
            while (n < n3 && n2 != 0) {
                if (nArray[n] == nArray[n4]) {
                    n2 = 0;
                }
                ++n;
            }
            if (n2 != 0) {
                nArray[n3++] = nArray[n4];
            }
            ++n4;
        }
        image.flush();
        int[] nArray2 = Parser.grabImage(image, dimension.width, dimension.height);
        n2 = 0;
        while (n2 < dimension.width * dimension.height) {
            n = 0;
            while (n < n3) {
                if (nArray2[n2] == nArray[n]) {
                    int n5 = n2;
                    nArray2[n5] = nArray2[n5] & 0xFFFFFF;
                }
                ++n;
            }
            ++n2;
        }
        return ImageCreator.createImage(new MemoryImageSource(dimension.width, dimension.height, dcm, nArray2, 0, dimension.width));
    }

    public static Image filterImage(Image image, int n, int n2, Color color, Color color2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color2.getRed();
        int n7 = color2.getGreen();
        int n8 = color2.getBlue();
        int[] nArray = Parser.grabImage(image, n, n2);
        int n9 = 0;
        while (n9 < n * n2) {
            if ((nArray[n9] & 0xFFFFFF) != 0xFFFFFF) {
                int cfr_ignored_0 = nArray[n9];
                int n10 = (nArray[n9] & 0xFF0000) >> 16;
                int n11 = (nArray[n9] & 0xFF00) >> 8;
                int n12 = nArray[n9] & 0xFF;
                n10 = n10 * (n3 - n6) / 255 + n6;
                n11 = n11 * (n4 - n7) / 255 + n7;
                n12 = n12 * (n5 - n8) / 255 + n8;
                nArray[n9] = 0xFF000000 | n10 << 16 | n11 << 8 | n12;
            } else {
                nArray[n9] = 0;
            }
            ++n9;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, dcm, nArray, 0, n);
        return ImageCreator.createImage(memoryImageSource);
    }

    private int skip() {
        int n = this.cur();
        while (!this.eof()) {
            if (n != 32 && n != 9 && n != 10) break;
            n = this.next();
        }
        return this.cur();
    }

    private Block getExternalBlock(String string) {
        TagParser tagParser = (TagParser)this.tags.get(string);
        if (tagParser == null) {
            throw new IllegalArgumentException("Parser for tag " + string + " is not registered");
        }
        return tagParser.parseTag(string);
    }

    private void init(Hashtable hashtable, String string) {
        this.props = new MetaTexProperties(hashtable, string);
        this.registerParsers();
    }

    private void init(String string, String string2) {
        this.props = new MetaTexProperties(string, string2);
        this.registerParsers();
    }

    public void registerTagParser(String string) {
        TagParser tagParser;
        try {
            tagParser = (TagParser)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            String string2 = "failed to load tag parser " + string + " due to " + throwable;
            System.err.println(string2);
            throwable.printStackTrace();
            throw new RuntimeException(string2);
        }
        String[] stringArray = tagParser.getHandledTags();
        int n = 0;
        while (n < stringArray.length) {
            this.tags.put(stringArray[n], tagParser);
            ++n;
        }
    }
}

