/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import physicon.metatex3.FontCache;
import physicon.metatex3.MetaTexFont;
import physicon.metatex3.ResourceLoader;

public class MetaTexProperties
implements Cloneable {
    private Hashtable properties;

    public Object get(Object object) {
        return this.properties.get(object);
    }

    public void set(Object object, Object object2) {
        this.properties.put(object, object2);
    }

    public boolean isTransparent() {
        return "true".equals(this.get("transparent"));
    }

    private MetaTexFont doGetFont(String string) {
        return (MetaTexFont)this.get("font" + string);
    }

    MetaTexProperties(String string, String string2) {
        if (string == null) {
            string = "/physicon/metatex3/resources.txt";
        }
        Class clazz = this.getLoader(string2);
        this.properties = ResourceLoader.loadProperties(string, clazz);
        this.patchProperties(string2);
    }

    MetaTexProperties(Hashtable hashtable, String string) {
        this.properties = hashtable;
        this.patchProperties(string);
    }

    public MetaTexFont getFont(int n) {
        String string = String.valueOf(n);
        if (n > 0) {
            string = "+" + string;
            MetaTexFont metaTexFont = this.doGetFont(string);
            if (metaTexFont != null) {
                return metaTexFont;
            }
            return this.getFont(n - 1);
        }
        MetaTexFont metaTexFont = this.doGetFont(string);
        if (metaTexFont != null) {
            return metaTexFont;
        }
        return this.getFont(n + 1);
    }

    void patchProperties(String string) {
        Object object;
        String string2 = (String)this.properties.get("locator");
        Class clazz = this.getLoader(string2 == null ? string : string2);
        this.properties.put("loader", clazz);
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith("font")) continue;
            String string4 = (String)this.properties.get(string3);
            object = new MetaTexFont(string4);
            FontCache.loadFont(object, clazz);
            this.properties.put(string3, object);
        }
        double d = 0.3;
        object = this.properties.get("space");
        if (object != null && object instanceof String) {
            try {
                d = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.properties.put("space", new Integer((int)((d *= (double)this.getFont(0).getSpaceMetric()[0]) + 0.5)));
    }

    public int getSpace() {
        return (Integer)this.get("space");
    }

    Class getLoader(String string) {
        try {
            if (string == null) {
                string = "physicon.metatex3.Locator";
            }
            Object obj = Class.forName(string).newInstance();
            return obj.getClass();
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to get loader for locator " + string);
        }
    }

    public Vector getParsers() {
        Vector vector = new Vector();
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = this.get(k);
            if (!object.equals("parser")) continue;
            vector.addElement(k);
        }
        return vector;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

