/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.GraphLibData;
import physicon.graphLib2.LineDrawer;
import physicon.graphLib2.ScaleDrawerBase;
import physicon.graphLib2.SolidLineDrawer;

public class LinearGridDrawer
extends ScaleDrawerBase {
    private LineDrawer lineDrawer = new SolidLineDrawer(this.getColor());
    public Point minOffset = null;
    public Point maxOffset = null;

    public void reset() {
        super.reset();
        this.minOffset = null;
        this.maxOffset = null;
    }

    public LinearGridDrawer() {
        super(GraphLibData.gridColor);
    }

    public LinearGridDrawer(Color color) {
        super(color);
    }

    public LineDrawer getLineDrawer() {
        return this.lineDrawer;
    }

    public void setLineDrawer(LineDrawer lineDrawer) {
        this.lineDrawer = lineDrawer;
    }

    public void drawLocal(Graphics graphics) {
        int n = this.dashesNumber();
        if (n == 0) {
            return;
        }
        if (this.getDash((int)0).x != this.getDash((int)(n - 1)).x && this.getDash((int)0).y != this.getDash((int)(n - 1)).y) {
            System.out.println("Warning!!! You are attempting to draw");
            System.out.println("oblique linear scale.");
            System.out.println("The library may not work properly");
        }
        graphics.setColor(this.getColor());
        int n2 = 0;
        while (n2 < n) {
            Point point = this.getDash(n2);
            Point point2 = new Point(point.x, point.y);
            Point point3 = new Point(point.x, point.y);
            point2.translate(this.minOffset.x, this.minOffset.y);
            point3.translate(this.maxOffset.x, this.maxOffset.y);
            this.getLineDrawer().setPoints(point2, point3);
            this.getLineDrawer().drawLocal(graphics);
            ++n2;
        }
    }

    public Rectangle getLocalRoughRect() {
        int n = this.dashesNumber();
        if (n == 0) {
            return new Rectangle(0, 0, 1, 1);
        }
        Point point = new Point(this.getDash((int)0).x, this.getDash((int)0).y);
        Point point2 = new Point(this.getDash((int)(n - 1)).x, this.getDash((int)(n - 1)).y);
        point.translate(this.minOffset.x, this.minOffset.y);
        point2.translate(this.maxOffset.x, this.maxOffset.y);
        Rectangle rectangle = new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y);
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        rectangle.grow(1, 1);
        return rectangle;
    }
}

