/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import physicon.graphLib2.DoublePoint;

public final class DoubleRectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public DoubleRectangle intersect(DoubleRectangle doubleRectangle) {
        this.normilize();
        doubleRectangle.normilize();
        double d = doubleRectangle.x - this.x;
        double d2 = doubleRectangle.y - this.y;
        if (d >= this.width || d2 >= this.height || d <= -doubleRectangle.width || d2 <= -doubleRectangle.height) {
            return new DoubleRectangle(0.0, 0.0, 0.0, 0.0);
        }
        DoubleRectangle doubleRectangle2 = new DoubleRectangle(this.x, this.y, d, d2);
        doubleRectangle2.normilize();
        return doubleRectangle2;
    }

    public void normilize() {
        if (this.width < 0.0) {
            this.x += this.width;
            this.width *= -1.0;
        }
        if (this.height < 0.0) {
            this.y += this.height;
            this.height *= -1.0;
        }
    }

    public String toString() {
        return new String("physicon.graphLib2.DoubleRectangle [x:" + this.x + " y:" + this.y + " width:" + this.width + " height:" + this.height + "]");
    }

    public DoubleRectangle(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public DoubleRectangle(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.x = doublePoint.x;
        this.y = doublePoint.y;
        this.width = doublePoint2.x - doublePoint.x;
        this.height = doublePoint2.y - doublePoint.y;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void translate(DoublePoint doublePoint) {
        this.x += doublePoint.x;
        this.y += doublePoint.y;
    }

    public boolean contains(DoublePoint doublePoint) {
        this.normilize();
        return doublePoint.x > this.x && doublePoint.x < this.x + this.width && doublePoint.y > this.y && doublePoint.y < this.y + this.height;
    }

    public boolean equals(DoubleRectangle doubleRectangle) {
        return this.x == doubleRectangle.x && this.y == doubleRectangle.y && this.width == doubleRectangle.width && this.height == doubleRectangle.height;
    }

    public void move(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void move(DoublePoint doublePoint) {
        this.x = doublePoint.x;
        this.y = doublePoint.y;
    }
}

