/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.DrawerBase;

public class ArrowDrawer
extends DrawerBase {
    public Point beginPoint;
    public Point endPoint;
    protected Color color;
    protected int arrowWidth;
    protected int arrowHeight;

    public void reset() {
        super.reset();
        this.beginPoint = null;
        this.endPoint = null;
    }

    public ArrowDrawer(Color color) {
        this.color = color;
        this.arrowWidth = 10;
        this.arrowHeight = 3;
        this.beginPoint = null;
        this.endPoint = null;
    }

    public ArrowDrawer(Color color, int n, int n2) {
        this.color = color;
        this.arrowWidth = n;
        this.arrowHeight = n2;
        this.beginPoint = null;
        this.endPoint = null;
    }

    public void drawLocal(Graphics graphics) {
        graphics.setColor(this.color);
        double d = this.endPoint.x - this.beginPoint.x;
        double d2 = this.endPoint.y - this.beginPoint.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n = d3 > (double)this.arrowWidth ? this.arrowWidth : (int)Math.floor(d3);
        double d4 = d * (d3 - (double)n) / d3;
        double d5 = d2 * (d3 - (double)n) / d3;
        int n2 = this.beginPoint.x + (int)Math.round(d4);
        int n3 = this.beginPoint.y + (int)Math.round(d5);
        graphics.drawLine(this.beginPoint.x, this.beginPoint.y, this.endPoint.x, this.endPoint.y);
        double d6 = d / d3;
        double d7 = d2 / d3;
        int[] nArray = new int[]{(int)Math.round((double)n2 - (double)this.arrowHeight * d7), (int)Math.round((double)n2 + (double)n * d6), (int)Math.round((double)n2 + (double)this.arrowHeight * d7)};
        int[] nArray2 = new int[]{(int)Math.round((double)n3 + (double)this.arrowHeight * d6), (int)Math.round((double)n3 + (double)n * d7), (int)Math.round((double)n3 - (double)this.arrowHeight * d6)};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public Rectangle getLocalRoughRect() {
        int n;
        int n2;
        int n3 = this.endPoint.x - this.beginPoint.x;
        int n4 = this.endPoint.y - this.beginPoint.y;
        if (n3 < 0) {
            n2 = this.endPoint.x;
            n3 *= -1;
        } else {
            n2 = this.beginPoint.x;
        }
        if (n4 < 0) {
            n = this.endPoint.y;
            n4 *= -1;
        } else {
            n = this.beginPoint.y;
        }
        Rectangle rectangle = new Rectangle(n2, n, n3, n4);
        rectangle.grow(this.arrowWidth + this.arrowHeight + 1, this.arrowWidth + this.arrowHeight + 1);
        return rectangle;
    }
}

