/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls.mart;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import physicon.controls.CUtil;

public class SliderCanvas
extends Canvas {
    boolean focused = false;
    private int min_shift = 0;
    private int max_shift = 0;
    private int m_accuracy;
    private int orientation;
    double m_step;
    double m_minVal;
    double m_curVal;
    double m_maxVal;
    private Vector m_actionListeners = new Vector();

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getMaxShift() {
        return this.max_shift;
    }

    public void setMaxShift(int n) {
        this.max_shift = n;
    }

    public int getThumbPosition() {
        return this.valueToPix(this.m_curVal);
    }

    public int getRange() {
        int n = this.getOrientation() == 0 ? this.getSize().width : this.getSize().height;
        return n - (this.getMinShift() + this.getMaxShift());
    }

    private double snap(double d) {
        int n = Math.max((int)Math.round((d - this.m_minVal) / this.m_step), 0);
        return this.round(this.m_minVal + (double)n * this.m_step);
    }

    protected void internalSetMin(double d) {
        this.m_minVal = this.round(d);
        this.internalSetMax(this.getMaxValue());
    }

    public void setMinValue(double d) {
        double d2 = this.getValue();
        this.internalSetMin(d);
        this.setValue(d2);
        if (d2 != this.getValue()) {
            this.notifyChange();
            this.notifyLast();
        }
    }

    public double getMinValue() {
        return this.m_minVal;
    }

    public void setValue(double d) {
        this.m_curVal = (d = this.snap(d)) < this.m_minVal ? this.m_minVal : (d > this.m_maxVal ? this.m_maxVal : d);
        this.repaint();
    }

    public double getValue() {
        return this.m_curVal;
    }

    public SliderCanvas(double d, double d2, double d3, int n) {
        this(d, d2, d3, 0.0, n);
    }

    public SliderCanvas(double d, double d2, double d3, double d4, int n) {
        this(d, d2, d3, d4, n, 0);
    }

    public SliderCanvas(double d, double d2, double d3, double d4, int n, int n2) {
        this.setCursor(new Cursor(12));
        this.setOrientation(n2);
        this.m_accuracy = n;
        this.m_minVal = this.round(d);
        this.m_step = this.round(Math.max(d4, Math.pow(10.0, -this.m_accuracy)));
        this.m_maxVal = this.snap(d2);
        this.setValue(d3);
        this.addFocusListener(new FocusListener(){
            {
                SliderCanvas.this.getClass();
            }

            public void focusLost(FocusEvent focusEvent) {
                SliderCanvas.this.focused = false;
                SliderCanvas.this.repaint();
            }

            public void focusGained(FocusEvent focusEvent) {
                SliderCanvas.this.focused = true;
                SliderCanvas.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SliderCanvas.this.setValue(SliderCanvas.this.m_curVal);
            }
            {
                SliderCanvas.this.getClass();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = SliderCanvas.this.getOrientation() == 0 ? mouseEvent.getX() : mouseEvent.getY();
                SliderCanvas.this.setValue(SliderCanvas.this.pixToValue(n));
                SliderCanvas.this.notifyChange();
            }
            {
                SliderCanvas.this.getClass();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SliderCanvas.this.notifyLast();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                double d = SliderCanvas.this.getValue();
                int n = SliderCanvas.this.getOrientation() == 0 ? mouseEvent.getX() : mouseEvent.getY();
                SliderCanvas.this.setValue(SliderCanvas.this.pixToValue(n));
                if (d != SliderCanvas.this.getValue()) {
                    SliderCanvas.this.notifyChange();
                }
            }
            {
                SliderCanvas.this.getClass();
            }
        });
        this.addKeyListener(new KeyAdapter(){
            {
                SliderCanvas.this.getClass();
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 37: {
                        SliderCanvas.this.setValue(SliderCanvas.this.m_curVal - SliderCanvas.this.m_step);
                        break;
                    }
                    case 39: {
                        SliderCanvas.this.setValue(SliderCanvas.this.m_curVal + SliderCanvas.this.m_step);
                        break;
                    }
                    case 36: {
                        SliderCanvas.this.setValue(SliderCanvas.this.m_minVal);
                        break;
                    }
                    case 35: {
                        SliderCanvas.this.setValue(SliderCanvas.this.m_maxVal);
                    }
                }
                SliderCanvas.this.notifyChange();
            }

            public void keyReleased(KeyEvent keyEvent) {
                SliderCanvas.this.notifyLast();
            }
        });
    }

    protected int valueToPix(double d) {
        int n = this.getRange();
        if (n <= 0 || d < this.getMinValue()) {
            return this.getMinShift();
        }
        if (d > this.getMaxValue()) {
            return this.getMinShift() + n;
        }
        double d2 = (this.getMaxValue() - this.getMinValue()) / (double)n;
        return this.getMinShift() + (int)Math.round((d - this.getMinValue()) / d2);
    }

    protected double pixToValue(int n) {
        int n2 = this.getRange();
        if (n2 <= 0 || n < this.getMinShift()) {
            return this.getMinValue();
        }
        if (n > this.getMinShift() + n2) {
            return this.getMaxValue();
        }
        double d = (this.getMaxValue() - this.getMinValue()) / (double)n2;
        return this.getMinValue() + (double)(n - this.getMinShift()) * d;
    }

    public void addNotify() {
        super.addNotify();
        this.dispatchEvent(new ComponentEvent(this, 101));
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListeners.removeElement(actionListener);
    }

    public void setMaxValue(double d) {
        double d2 = this.getValue();
        this.internalSetMax(d);
        this.setValue(d2);
        if (d2 != this.getValue()) {
            this.notifyChange();
            this.notifyLast();
        }
    }

    public double getMaxValue() {
        return this.m_maxVal;
    }

    protected void notifyChange() {
        this.processActionEvent(new ActionEvent(this, -1, CUtil.fString(this.m_curVal, this.m_accuracy)));
    }

    public void setStep(double d) {
        this.m_step = this.round(Math.max(d, Math.pow(10.0, -this.m_accuracy)));
        this.setMaxValue(this.m_maxVal);
    }

    public double getStep() {
        return this.m_step;
    }

    protected void notifyLast() {
        this.processActionEvent(new ActionEvent(this, 0, CUtil.fString(this.m_curVal, this.m_accuracy)));
    }

    private void processActionEvent(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.m_actionListeners.size()) {
            ((ActionListener)this.m_actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    protected void internalSetMax(double d) {
        this.m_maxVal = this.snap(d);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListeners.addElement(actionListener);
    }

    public int getMinShift() {
        return this.min_shift;
    }

    public void setMinShift(int n) {
        this.min_shift = n;
    }

    private double round(double d) {
        double d2 = Math.pow(10.0, this.m_accuracy);
        return (double)Math.round(d * d2) / d2;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public int getOrientation() {
        return this.orientation;
    }
}

