/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls.mart;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import physicon.controls.CUtil;
import physicon.controls.ICheckbox;
import physicon.controls.IComponent;
import physicon.controls.IItem;
import physicon.controls.Image1x1;
import physicon.controls.ImageMagic;
import physicon.controls.mart.CBGroup;

public class SCheckbox
extends Canvas
implements ICheckbox {
    Component m_comp;
    boolean focused = false;
    protected static final int CHECKBOX = 0;
    protected static final int RADIO = 1;
    private int cbWidth;
    private boolean m_state;
    private String m_label;
    private IItem m_item = null;
    protected Image disabledItemImage;
    private Image[] m_trueEnabled = new Image[]{new Image1x1("techeckbox.gif"), new Image1x1("teradio.gif")};
    private Image[] m_trueDisabled = new Image[]{new Image1x1("tdcheckbox.gif"), new Image1x1("tdradio.gif")};
    private Image[] m_falseEnabled = new Image[]{new Image1x1("fecheckbox.gif"), new Image1x1("feradio.gif")};
    private Image[] m_falseDisabled = new Image[]{new Image1x1("fdcheckbox.gif"), new Image1x1("fdradio.gif")};
    private int m_controlType;
    Image m_buffer;
    private CBGroup m_group;
    private Vector m_itemListeners = new Vector();

    public Object[] getSelectedObjects() {
        if (this.m_state) {
            return new Object[]{this.m_label};
        }
        return null;
    }

    public void setState(boolean bl) {
        if (this.getState() == bl) {
            return;
        }
        this.m_state = bl;
        if (this.m_group != null) {
            if (!this.m_state && this.equals(this.m_group.selectedCheckbox)) {
                this.m_group.selectedCheckbox = null;
            }
            if (this.m_state) {
                this.m_group.setSelectedCheckbox(this);
            }
        }
        this.repaint();
    }

    public boolean getState() {
        return this.m_state;
    }

    public void setSkin(Image[] imageArray, Image[] imageArray2, Image[] imageArray3, Image[] imageArray4) {
        this.m_falseEnabled = imageArray;
        this.m_falseDisabled = imageArray2;
        this.m_trueEnabled = imageArray3;
        this.m_trueDisabled = imageArray4;
    }

    protected void drawRelief(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Image image = this.getPicture();
        this.cbWidth = image.getWidth(this) + 3;
        CUtil.drawImage(graphics, image, 0, (dimension.height - image.getHeight(this)) / 2, null, this);
        if (this.isFocused()) {
            // empty if block
        }
    }

    protected void drawItem(Graphics graphics) {
        if (this.m_item == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.m_item.getRoughRect();
        if (!this.isEnabled()) {
            graphics.drawImage(this.disabledItemImage, this.cbWidth, (dimension.height - rectangle.height) / 2, this);
            return;
        }
        int n = -rectangle.x + this.cbWidth;
        int n2 = -rectangle.y + (dimension.height - rectangle.height) / 2;
        graphics.translate(n, n2);
        this.m_item.paint(graphics);
        graphics.translate(-n, -n2);
    }

    public void paint(Graphics graphics) {
        if (this.m_buffer == null) {
            this.dispatchEvent(new ComponentEvent(this, 101));
        }
        Graphics graphics2 = this.m_buffer.getGraphics();
        this.drawRelief(graphics2);
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        this.drawItem(graphics2);
        this.drawLabel(graphics2);
        graphics.drawImage(this.m_buffer, 0, 0, this);
    }

    public Component getAWTComponent() {
        return this;
    }

    public SCheckbox(String string, boolean bl, CBGroup cBGroup) {
        this.m_comp = this;
        this.setCursor(new Cursor(12));
        this.m_label = string;
        this.m_state = bl;
        this.m_group = cBGroup;
        this.m_controlType = 0;
        if (this.m_group != null) {
            this.m_controlType = 1;
            this.m_group.group = null;
            if (bl) {
                this.m_group.setSelectedCheckbox(this);
            }
        }
        this.addFocusListener(new FocusListener(){
            {
                SCheckbox.this.getClass();
            }

            public void focusLost(FocusEvent focusEvent) {
                SCheckbox.this.focused = false;
                SCheckbox.this.repaint();
            }

            public void focusGained(FocusEvent focusEvent) {
                SCheckbox.this.focused = true;
                SCheckbox.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SCheckbox.this.requestFocus();
                SCheckbox.this.notifyChange();
            }
            {
                SCheckbox.this.getClass();
            }
        });
        this.addKeyListener(new KeyAdapter(){
            {
                SCheckbox.this.getClass();
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 10: 
                    case 32: {
                        SCheckbox.this.notifyChange();
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SCheckbox.this.m_buffer = SCheckbox.this.m_comp.createImage(SCheckbox.this.getSize().width, SCheckbox.this.getSize().height);
            }
            {
                SCheckbox.this.getClass();
            }
        });
    }

    protected Image getPicture() {
        if (this.m_state) {
            if (this.isEnabled()) {
                return this.m_trueEnabled[this.m_controlType];
            }
            return this.m_trueDisabled[this.m_controlType];
        }
        if (this.isEnabled()) {
            return this.m_falseEnabled[this.m_controlType];
        }
        return this.m_falseDisabled[this.m_controlType];
    }

    protected void notifyChange() {
        if (this.m_group != null) {
            this.m_group.setSelectedCheckbox(this);
        } else {
            this.m_state = !this.m_state;
        }
        this.processItemEvent(new ItemEvent(this, 701, this, this.m_state ? 1 : 2));
        this.repaint();
    }

    public void setComponent(Component component) {
        this.m_comp = component;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.m_itemListeners.removeElement(itemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_itemListeners.addElement(itemListener);
    }

    public void setCheckboxGroup(CBGroup cBGroup) {
        if (cBGroup.equals(this.m_group)) {
            return;
        }
        if (this.m_group == null) {
            this.m_controlType = 1;
        } else if (this.m_state) {
            this.m_group.selectedCheckbox = null;
        }
        this.m_group = cBGroup;
        this.m_group.group = null;
        if (this.m_state) {
            this.m_group.setSelectedCheckbox(this);
        }
        this.repaint();
    }

    public CBGroup getCheckboxGroup() {
        return this.m_group;
    }

    private void processItemEvent(ItemEvent itemEvent) {
        int n = 0;
        while (n < this.m_itemListeners.size()) {
            ((ItemListener)this.m_itemListeners.elementAt(n)).itemStateChanged(itemEvent);
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.repaint();
    }

    public void setItemLabel(IItem iItem) {
        this.m_item = iItem;
        if (this.m_item != null) {
            this.disabledItemImage = CUtil.itemToImage(this.m_item, this.getBackground(), this.getForeground());
            this.disabledItemImage = ImageMagic.createDisabledImage(this.disabledItemImage, null);
        }
        this.repaint();
    }

    public IItem getItemLabel() {
        return this.m_item;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_buffer == null) {
            return;
        }
        this.m_buffer.flush();
        if (!IComponent.isMicrosoft) {
            return;
        }
        this.m_buffer = null;
        System.gc();
    }

    public void setLabel(String string) {
        this.m_label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.m_label;
    }

    protected void drawLabel(Graphics graphics) {
        if (this.isEnabled()) {
            CUtil.drawText(graphics, this.m_label, this.cbWidth, this.getSize().height / 2, 33);
            return;
        }
        CUtil.drawDisabledText(graphics, this.m_label, this.cbWidth, this.getSize().height / 2, 33);
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

