/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class ViewPane
extends Canvas
implements MouseListener,
MouseMotionListener {
    private Image image;
    private int x;
    private int y;
    private int x_step = 1;
    private int y_step = 1;
    private Point lastMouse;
    private boolean showVerticalScrollbar = false;
    private boolean showHorizontalScrollbar = false;
    private boolean mouseEnabled = true;
    private Vector m_actionListeners = new Vector();

    public void mouseReleased(MouseEvent mouseEvent) {
        this.notifyLast();
    }

    public int getYPos() {
        return this.y;
    }

    private void internalSetYPos(int n) {
        int n2 = Math.max(this.getImage().getHeight(this) - this.getSize().height, 0);
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        this.y = n;
    }

    public void setYPos(int n) {
        this.internalSetYPos(this.snap(n, this.getYstep()));
        this.repaint();
    }

    public int getXstep() {
        return this.x_step;
    }

    public void setXstep(int n) {
        this.x_step = n;
    }

    private void processActionEvent(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.m_actionListeners.size()) {
            ((ActionListener)this.m_actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(0));
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.internalSetXPos(0);
        this.internalSetYPos(0);
        this.repaint();
    }

    public boolean isShowVerticalScrollbar() {
        return this.showVerticalScrollbar;
    }

    public void setShowHorizontalScrollbar(boolean bl) {
        this.showHorizontalScrollbar = bl;
    }

    public int getXPos() {
        return this.x;
    }

    private void internalSetXPos(int n) {
        int n2 = Math.max(this.getImage().getWidth(this) - this.getSize().width, 0);
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        this.x = n;
    }

    public void setXPos(int n) {
        this.internalSetXPos(this.snap(n, this.getXstep()));
        this.repaint();
    }

    public boolean isShowHorizontalScrollbar() {
        return this.showHorizontalScrollbar;
    }

    private int snap(int n, int n2) {
        return (int)((long)n2 * Math.round((double)n / (double)n2));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent.getPoint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getImage() == null || !this.isMouseEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point.translate(-this.lastMouse.x, -this.lastMouse.y);
        point.x = this.snap(point.x, this.getXstep());
        point.y = this.snap(point.y, this.getYstep());
        if (point.x != 0) {
            this.internalSetXPos(this.getXPos() - point.x);
        }
        if (point.y != 0) {
            this.internalSetYPos(this.getYPos() - point.y);
        }
        this.notifyChange();
        this.lastMouse.translate(point.x, point.y);
        this.repaint();
    }

    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    public ViewPane() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.getImage() != null) {
            graphics.drawImage(this.getImage(), -this.getXPos(), -this.getYPos(), this);
        }
    }

    public boolean isMouseEnabled() {
        return this.mouseEnabled;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListeners.removeElement(actionListener);
    }

    protected void notifyChange() {
        this.processActionEvent(new ActionEvent(this, -1, "first [" + this.getXPos() + ", " + this.getYPos() + "]"));
    }

    protected void notifyLast() {
        this.processActionEvent(new ActionEvent(this, 0, "last [" + this.getXPos() + ", " + this.getYPos() + "]"));
    }

    public int getYstep() {
        return this.y_step;
    }

    public void setYstep(int n) {
        this.y_step = n;
    }

    public void setShowVerticalScrollbar(boolean bl) {
        this.showVerticalScrollbar = bl;
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListeners.addElement(actionListener);
    }
}

