/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import physicon.controls.CUtil;
import physicon.controls.Image1x1;
import physicon.controls.mart.SButton;
import physicon.controls.mart.SliderCanvas;
import physicon.objava3.SequenceController;
import physicon.objava3.SimButton;
import physicon.objava3.SimConfig;
import physicon.objava3.SimWindow;

public abstract class ThermoCanvas
extends SimWindow
implements SequenceController {
    int thermWidth = 27;
    private CUtil.ScaleDrawer scaleDrawer;
    private Thermometer thermometer;
    private SimButton upBtn;
    private SimButton downBtn;
    SliderCanvas slc;
    private int space = 3;

    public CUtil.ScaleDrawer getScaleDrawer() {
        return this.scaleDrawer;
    }

    public void setScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.scaleDrawer = scaleDrawer;
    }

    public void setValue(double d) {
        this.slc.setValue(this.getMaxValue() + this.getMinValue() - d);
    }

    public double getValue() {
        return this.getMaxValue() + this.getMinValue() - this.slc.getValue();
    }

    public void setMinValue(double d) {
        this.scaleDrawer.setMin(d);
        this.slc.setMinValue(d);
    }

    public double getMinValue() {
        return this.slc.getMinValue();
    }

    public ThermoCanvas(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        CUtil.ScaleDrawer scaleDrawer = new CUtil.ScaleDrawer(d2, d3, 10.0 * d4, 10, SimConfig.SCALE_FONT_COLOR);
        scaleDrawer.setFromLabelToLabel(false);
        this.setScaleDrawer(scaleDrawer);
        this.getScaleDrawer().setOrientation(1);
        Image1x1 image1x1 = new Image1x1("eupbtn.gif");
        Dimension dimension2 = new Dimension(((Image)image1x1).getWidth(null), ((Image)image1x1).getHeight(null));
        this.slc = new SliderCanvas(d2, d3, d3 + d2 - d, d4, 0, 1){

            public void paint(Graphics graphics) {
                if (!ThermoCanvas.this.isCreated()) {
                    return;
                }
                ThermoCanvas.this.paintAll();
                ThermoCanvas.this.flushBuffer(graphics);
            }
            {
                ThermoCanvas.this.getClass();
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        this.slc.addActionListener(new ActionListener(){
            {
                ThermoCanvas.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getID() == -1) {
                    ThermoCanvas.this.notifyChange();
                    return;
                }
                ThermoCanvas.this.notifyLast();
            }
        });
        this.slc.addMouseListener(this);
        this.slc.setBounds(0, 0, dimension.width, dimension.height - dimension2.height);
        int n = (dimension.width - 2 * dimension2.width) / 3;
        this.upBtn = new SimButton(this, new Point(n, dimension.height - dimension2.height), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("edownbtn.gif"), new Image1x1("ddownbtn.gif"), new Image1x1("pdownbtn.gif"));
            }
            {
                ThermoCanvas.this.getClass();
            }

            public void notifyChange() {
                if (ThermoCanvas.this.getValue() <= ThermoCanvas.this.getMinValue()) {
                    return;
                }
                ThermoCanvas.this.setValue(ThermoCanvas.this.getValue() - ThermoCanvas.this.getStep());
                ThermoCanvas.this.notifyChange();
            }

            public void notifyLast() {
                ThermoCanvas.this.notifyLast();
            }
        };
        this.downBtn = new SimButton(this, new Point(2 * n + dimension2.width, dimension.height - dimension2.height), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("eupbtn.gif"), new Image1x1("dupbtn.gif"), new Image1x1("pupbtn.gif"));
            }
            {
                ThermoCanvas.this.getClass();
            }

            public void notifyChange() {
                if (ThermoCanvas.this.getValue() >= ThermoCanvas.this.getMaxValue()) {
                    return;
                }
                ThermoCanvas.this.setValue(ThermoCanvas.this.getValue() + ThermoCanvas.this.getStep());
                ThermoCanvas.this.notifyChange();
            }

            public void notifyLast() {
                ThermoCanvas.this.notifyLast();
            }
        };
        this.thermometer = new Thermometer();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.slc.getSize();
        graphics.setColor(SimConfig.bkgColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setFont(new Font(SimConfig.CONTROL_FONT.getFamily(), SimConfig.CONTROL_FONT.getStyle(), 10));
        int n = (int)Math.round((double)this.getSpace() * (this.getMaxValue() - this.getMinValue()) / this.getStep());
        this.slc.setMinShift(dimension.height - (n + this.slc.getMaxShift()));
        this.getScaleDrawer().draw(graphics, new Rectangle(0, this.slc.getMinShift(), dimension.width - this.thermWidth, dimension.height - (this.slc.getMinShift() + this.slc.getMaxShift())));
        this.thermometer.draw(graphics);
        this.getFactory().drawRelief(graphics, 0, 0, dimension.width, dimension.height, null, this);
    }

    public abstract void notifyLast();

    public abstract void notifyChange();

    public void setMaxValue(double d) {
        this.scaleDrawer.setMax(d);
        this.slc.setMaxValue(d);
    }

    public double getMaxValue() {
        return this.slc.getMaxValue();
    }

    public double getStep() {
        return this.slc.getStep();
    }

    public void setStep(double d) {
        this.slc.setStep(d);
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int n) {
        this.space = n;
        this.slc.repaint();
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.slc);
        return panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.upBtn.setEnabled(bl);
        this.downBtn.setEnabled(bl);
    }

    class Thermometer {
        ImageObserver obs;
        private Image top;
        private Image bottom;
        private Image fill;
        private Image empty;
        private Image pointer;

        public void draw(Graphics graphics) {
            Dimension dimension = ThermoCanvas.this.slc.getSize();
            int n = dimension.width - ThermoCanvas.this.thermWidth;
            int n2 = 0;
            int n3 = this.top.getHeight(this.obs);
            graphics.setColor(SimConfig.hostBkgColor);
            graphics.fillRect(n + 2, 0, ThermoCanvas.this.thermWidth - 2, dimension.height);
            CUtil.drawImage(graphics, this.top, n, n2, ThermoCanvas.this.thermWidth, n3, null, this.obs);
            n2 += n3;
            n3 = ThermoCanvas.this.slc.getThumbPosition() - n2;
            CUtil.drawImage(graphics, this.empty, n, n2, ThermoCanvas.this.thermWidth, n3, null, this.obs);
            n2 += n3;
            n3 = dimension.height - (n2 + ThermoCanvas.this.slc.getMaxShift());
            CUtil.drawImage(graphics, this.fill, n, n2, ThermoCanvas.this.thermWidth, n3, null, this.obs);
            CUtil.drawImage(graphics, this.pointer, n + 2, n2 - this.pointer.getHeight(this.obs) / 2, null, this.obs);
            n2 += n3;
            n3 = ThermoCanvas.this.slc.getMaxShift();
            CUtil.drawImage(graphics, this.bottom, n, n2, ThermoCanvas.this.thermWidth, n3, null, this.obs);
        }

        public Thermometer() {
            ThermoCanvas.this.getClass();
            this.obs = ThermoCanvas.this;
            this.top = ThermoCanvas.this.getImage("therm_top.gif", this);
            this.bottom = ThermoCanvas.this.getImage("therm_bottom.gif", this);
            this.fill = ThermoCanvas.this.getImage("therm_mid_fill.gif", this);
            this.empty = ThermoCanvas.this.getImage("therm_mid_empty.gif", this);
            this.pointer = ThermoCanvas.this.getImage("pointer.gif", this);
            ThermoCanvas.this.slc.setMaxShift(this.bottom.getHeight(this.obs));
            ThermoCanvas.this.thermWidth = this.top.getWidth(this.obs);
        }
    }
}

