/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import physicon.objava3.Region;
import physicon.objava3.SequenceController;
import physicon.objava3.SimObject;
import physicon.objava3.more.PointConvertor;

public class PointAndClick
extends Region
implements SequenceController {
    private boolean m_isDragging = false;
    private String m_eventName;
    private String m_setEventName;
    private Point m_lastPoint;
    private PointConvertor m_pointConvertor;

    public PointAndClick(SimObject simObject, String string, String string2) {
        super(simObject, new Point(0, 0));
        this.m_eventName = string;
        this.m_setEventName = string2;
        this.m_pointConvertor = null;
    }

    public PointAndClick(SimObject simObject, String string) {
        this(simObject, string, string == null ? null : string + "Set");
    }

    public void paint(Graphics graphics) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.m_isDragging) {
            this.notifyLast();
            this.releaseCapture();
            this.m_isDragging = false;
        }
    }

    public final void setPointConvertor(PointConvertor pointConvertor) {
        this.m_pointConvertor = pointConvertor;
    }

    public boolean contains(int n, int n2) {
        Point point = new Point(n, n2);
        return this.m_pointConvertor.convertPoint(point) == point;
    }

    public void notifyLast() {
        if (this.m_setEventName != null) {
            this.publishEvent(this.m_setEventName, this.m_lastPoint);
        }
    }

    public void notifyChange() {
        if (this.m_eventName != null) {
            this.publishEvent(this.m_eventName, this.m_lastPoint);
        }
    }

    public Rectangle getRoughRect() {
        return new Rectangle();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.setCapture();
        this.m_isDragging = true;
        this.m_lastPoint = this.m_pointConvertor.convertPoint(mouseEvent.getPoint());
        this.notifyChange();
    }

    public void mouseDrag(MouseEvent mouseEvent) {
        this.m_lastPoint = this.m_pointConvertor.convertPoint(mouseEvent.getPoint());
        this.notifyChange();
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }
}

