/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import physicon.controls.IButton;
import physicon.controls.IItem;
import physicon.objava3.SequenceController;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimWindow;

public class SimButton
extends SimWindow
implements ActionListener,
SequenceController {
    private String m_eventName;
    private String m_setEventName;
    protected IButton m_bt;

    public void requestFocus() {
        this.m_bt.requestFocus();
    }

    public SimButton(SimWindow simWindow, Point point, Dimension dimension, String string, String string2, String string3) {
        super(simWindow, point, dimension);
        this.m_eventName = string2;
        this.m_setEventName = string3;
        this.m_bt = this.getFactory().createButton(string.toLowerCase());
        this.m_bt.setBounds(0, 0, dimension.width, dimension.height);
        this.m_bt.addActionListener(this);
        this.m_bt.addMouseListener(this);
    }

    public SimButton(SimWindow simWindow, Point point, Dimension dimension, String string, String string2) {
        this(simWindow, point, dimension, string, string2, string2 == null ? null : string2 + "Set");
    }

    public boolean isPressed() {
        return this.m_bt.isPressed();
    }

    public void notifyLast() {
        if (this.m_setEventName != null) {
            this.publishEvent(this.m_setEventName, null);
        }
    }

    public void notifyChange() {
        if (this.m_eventName != null) {
            this.publishEvent(this.m_eventName, null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyChange();
        if (actionEvent.getID() == 0) {
            this.notifyLast();
        }
    }

    public void setStringValue(String string) {
        this.setLabel(string);
    }

    public String getStringValue() {
        return this.getLabel();
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.m_bt.getAWTComponent());
        return panel;
    }

    public void setEnabled(boolean bl) {
        this.m_bt.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setItemLabel(String string) {
        this.setItemLabel(string, 0);
    }

    public void setItemLabel(String string, int n) {
        SimMetaTeXBlock simMetaTeXBlock = new SimMetaTeXBlock(this.getParent(), new Point(), string, n);
        simMetaTeXBlock.setVisible(false);
        this.setItemLabel(simMetaTeXBlock);
    }

    public void setItemLabel(IItem iItem) {
        this.m_bt.setItemLabel(iItem);
    }

    public void setItemLabel(IItem iItem, IItem iItem2, IItem iItem3) {
        this.m_bt.setItemLabel(iItem, iItem2, iItem3);
    }

    public boolean isFocused() {
        return this.m_bt.isFocused();
    }

    public void setLabel(String string) {
        this.m_bt.setLabel(string.toLowerCase());
    }

    public String getLabel() {
        return this.m_bt.getLabel();
    }
}

