/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import java.util.Vector;
import physicon.graphLib2.CurveDrawerBase;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphCurveBase;

public class PointArrayCurve
extends GraphCurveBase {
    private Vector points = new Vector();

    public DoublePoint getPointAt(int n) {
        return (DoublePoint)this.points.elementAt(n);
    }

    public PointArrayCurve(CurveDrawerBase curveDrawerBase) {
        super(curveDrawerBase);
    }

    public void removePointAt(int n) {
        this.points.removeElementAt(n);
        this.setRedrawFlag(true);
    }

    public double getMinParamValue() {
        return 0.0;
    }

    public double getMaxParamValue() {
        return this.points.size() - 1;
    }

    public DoublePoint getLocalPoint(double d) {
        int n = (int)Math.round(Math.ceil(d));
        int n2 = (int)Math.round(Math.floor(d));
        int n3 = this.points.size();
        if (n3 == 0) {
            System.out.println("Warning!!! Painting empty Point Array");
            return new DoublePoint(0.0, 0.0);
        }
        if (n > n3 - 1) {
            n = n3 - 1;
        } else if (n < 0) {
            n = 0;
        }
        if (n2 > n3 - 1) {
            n2 = n3 - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        DoublePoint doublePoint = this.getPointAt(n);
        DoublePoint doublePoint2 = this.getPointAt(n2);
        if (n2 == n) {
            return new DoublePoint(doublePoint);
        }
        return new DoublePoint(doublePoint.x + (d - (double)n) * (doublePoint2.x - doublePoint.x) / (double)(n2 - n), doublePoint.y + (d - (double)n) * (doublePoint2.y - doublePoint.y) / (double)(n2 - n));
    }

    public int pointsNumber() {
        return this.points.size();
    }

    public void updateDrawer() {
        super.updateDrawer();
        GraphContextBase graphContextBase = this.getContext();
        CurveDrawerBase curveDrawerBase = (CurveDrawerBase)this.getDrawer();
        int n = this.pointsNumber();
        int n2 = 0;
        while (n2 < n) {
            Point point = graphContextBase.lp2gp(this.getPointAt(n2));
            if (Math.abs(point.y) > 10000) {
                curveDrawerBase.addBreakPoint(point);
            } else {
                curveDrawerBase.addPoint(point);
            }
            ++n2;
        }
    }

    public void removeAllPoints() {
        this.points.removeAllElements();
        this.setRedrawFlag(true);
    }

    public void insertPointAt(DoublePoint doublePoint, int n) {
        if (n == -1) {
            this.points.addElement(doublePoint);
        } else {
            this.points.insertElementAt(doublePoint, n);
        }
        this.setRedrawFlag(true);
    }
}

