/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.LabelDrawer;
import physicon.graphLib2.MetaTeXBlock;

public class MetaTeXLabelDrawer
extends LabelDrawer {
    MetaTeXBlock text = new MetaTeXBlock();

    public MetaTeXLabelDrawer(String string) {
        this.setText(string);
    }

    public MetaTeXLabelDrawer(String string, int n, int n2) {
        super(n, n2);
        this.setText(string);
    }

    public void drawLocal(Graphics graphics) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.font);
        Rectangle rectangle = this.getLocalRoughRect();
        if (this.getBackColor() != null) {
            graphics.setColor(this.getBackColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.getTextColor());
        this.text.paint(graphics, rectangle.x, rectangle.y);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Rectangle getLocalRoughRect() {
        Dimension dimension = this.text.getSize();
        ++dimension.width;
        dimension.height += 2;
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        switch (this.hAlignment) {
            case 1: {
                rectangle.x -= dimension.width;
                break;
            }
            case 2: {
                rectangle.x -= dimension.width / 2;
            }
        }
        switch (this.vAlignment) {
            case 1: {
                rectangle.y -= dimension.height;
                break;
            }
            case 3: {
                rectangle.y -= this.text.getAscent();
                break;
            }
            case 2: {
                rectangle.y -= this.text.getAscent() - dimension.height / 2;
            }
        }
        rectangle.x += this.getOffset().x;
        rectangle.y += this.getOffset().y;
        return rectangle;
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public String getText() {
        return this.text.getText();
    }
}

