/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphScaleBase;
import physicon.graphLib2.LinearScaleDrawer;

public class LinearScale
extends GraphScaleBase {
    private DoublePoint minDpt;
    private DoublePoint maxDpt;
    private boolean horAxis;
    private double step;
    private double norm;
    private boolean auto;
    private int dashPerBlock;
    private int numberOfLargeDashes;

    public void setRange(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.minDpt = doublePoint;
        this.maxDpt = doublePoint2;
        boolean bl = this.horAxis = this.minDpt.y == this.maxDpt.y;
        if (this.minDpt.x != this.maxDpt.x && this.minDpt.y != this.maxDpt.y) {
            System.out.println("Warning!!! You are attempting to create");
            System.out.println("oblique linear scale.");
            System.out.println("The library may not work properly");
        }
        if (this.horAxis) {
            this.setMinParam(this.minDpt.x);
            this.setMaxParam(this.maxDpt.x);
            return;
        }
        this.setMinParam(this.minDpt.y);
        this.setMaxParam(this.maxDpt.y);
    }

    public LinearScale(LinearScaleDrawer linearScaleDrawer, DoublePoint doublePoint, DoublePoint doublePoint2, int n) {
        super(linearScaleDrawer);
        this.minDpt = doublePoint;
        this.maxDpt = doublePoint2;
        boolean bl = this.horAxis = this.minDpt.y == this.maxDpt.y;
        if (this.minDpt.x != this.maxDpt.x && this.minDpt.y != this.maxDpt.y) {
            System.out.println("Warning!!! You are attempting to create");
            System.out.println("oblique linear scale.");
            System.out.println("The library may not work properly");
        }
        if (this.horAxis) {
            this.setMinParam(this.minDpt.x);
            this.setMaxParam(this.maxDpt.x);
        } else {
            this.setMinParam(this.minDpt.y);
            this.setMaxParam(this.maxDpt.y);
        }
        this.step = 1.0;
        this.norm = 1.0;
        this.auto = true;
        this.dashPerBlock = 2;
        this.numberOfLargeDashes = n;
    }

    public LinearScale(LinearScaleDrawer linearScaleDrawer, DoublePoint doublePoint, DoublePoint doublePoint2) {
        this(linearScaleDrawer, doublePoint, doublePoint2, 0);
    }

    public void setManualMode(double d, double d2, int n) {
        this.auto = false;
        this.step = d;
        this.norm = d2;
        this.dashPerBlock = n;
        this.setRedrawFlag(true);
    }

    public void setAutoMode() {
        this.auto = true;
        this.setRedrawFlag(true);
    }

    public DoublePoint getMinPoint() {
        return new DoublePoint(this.minDpt);
    }

    void setStep(double d, double d2, int n) {
        int n2;
        double d3 = d2 - d;
        double d4 = Math.pow(10.0, Math.ceil(Math.log(d3) / Math.log(10.0)));
        double d5 = 1.0;
        int n3 = n * 2;
        double d6 = 1.0;
        double d7 = 1.0;
        do {
            if (n3 > Math.abs((n2 = (int)Math.round(d3 / d5 / d4)) - n)) {
                n3 = Math.abs(n2 - n);
                d6 = d5 * d4;
                d7 = d4;
            }
            if (d5 == 1.0) {
                d5 = 0.5;
                continue;
            }
            if (d5 == 0.5) {
                d5 = 0.2;
                continue;
            }
            d5 = 1.0;
            d4 /= 10.0;
        } while (n2 < n * 2);
        if (d6 / d7 == 1.0) {
            d7 *= 10.0;
        }
        d7 = 1.0 / d7;
        this.setManualMode(d6, d7 * 10.0, 2);
    }

    public void setMinParam(double d) {
        super.setMinParam(d);
        if (this.horAxis) {
            this.minDpt.x = d;
            return;
        }
        this.minDpt.y = d;
    }

    public synchronized void updateDrawer() {
        try {
            double d;
            double d2;
            super.updateDrawer();
            LinearScaleDrawer linearScaleDrawer = (LinearScaleDrawer)this.getDrawer();
            double d3 = this.horAxis ? this.minDpt.x : this.minDpt.y;
            double d4 = d2 = this.horAxis ? this.maxDpt.x : this.maxDpt.y;
            if (d3 > d2) {
                double d5 = d3;
                d3 = d2;
                d2 = d5;
            }
            if (this.numberOfLargeDashes != 0) {
                this.setStep(d3, d2, this.numberOfLargeDashes);
            }
            int n = 0;
            Graphics graphics = this.getContainer().getComponent().getGraphics();
            FontMetrics fontMetrics = graphics == null ? null : graphics.getFontMetrics();
            int n2 = n - 1;
            double d6 = this.dashPerBlock;
            Point point = this.horAxis ? this.getContext().lp2gp(new DoublePoint(d3, this.minDpt.y)) : this.getContext().lp2gp(new DoublePoint(this.minDpt.x, d3));
            Point point2 = this.horAxis ? this.getContext().lp2gp(new DoublePoint(d2, this.maxDpt.y)) : this.getContext().lp2gp(new DoublePoint(this.maxDpt.x, d2));
            Point point3 = new Point(point2.x, point2.y);
            point3.translate(-point.x, -point.y);
            Rectangle rectangle = new Rectangle(point.x, point.y, point3.x, point3.y);
            if (rectangle.width < 0) {
                rectangle.x += rectangle.width;
                rectangle.width *= -1;
            }
            if (rectangle.height < 0) {
                rectangle.y += rectangle.height;
                rectangle.height *= -1;
            }
            --rectangle.x;
            --rectangle.y;
            rectangle.width += 2;
            rectangle.height += 2;
            double d7 = Math.round(d3 * this.norm);
            d3 = d7 / this.norm;
            d2 = (double)Math.round(d2 * this.norm) / this.norm;
            String string = String.valueOf(d2);
            Rectangle rectangle2 = fontMetrics != null ? new Rectangle(0, 0, fontMetrics.stringWidth(string), fontMetrics.getHeight()) : new Rectangle(0, 0, 1, 1);
            rectangle2.grow(2, 2);
            if (this.auto) {
                int n3;
                while (Math.round(d2 * Math.pow(10.0, ++n2)) - Math.round(d3 * Math.pow(10.0, n2)) < 5L) {
                }
                this.norm = Math.pow(10.0, n2);
                d = this.horAxis ? 1.0 * (double)rectangle.width / (double)rectangle2.width : 1.0 * (double)rectangle.height / (double)rectangle2.height;
                this.step = this.norm;
                double d8 = 1.0;
                d6 = 0.0;
                do {
                    this.step = 1.0 / this.norm * (d6 += 1.0);
                    DoublePoint doublePoint = this.horAxis ? new DoublePoint(d3 + this.step, this.minDpt.y) : new DoublePoint(this.minDpt.x, d3 + this.step);
                    Point point4 = this.getContext().lp2gp(doublePoint);
                    int n4 = n3 = this.horAxis ? Math.abs(point4.x - point.x) : Math.abs(point4.y - point.y);
                    if (n3 != 0) continue;
                    n3 = 1;
                } while ((d8 = this.horAxis ? 1.0 * (double)rectangle.width / (double)n3 : 1.0 * (double)rectangle.height / (double)n3) > d);
                double d9 = d8;
                double d10 = 0.0;
                while (d6 > 10.0) {
                    d10 += 1.0;
                    d6 /= 10.0;
                }
                if (d6 > 5.0) {
                    d6 = 10.0;
                    this.dashPerBlock = 10;
                } else if (d6 > 4.0) {
                    d6 = 5.0;
                    this.dashPerBlock = 5;
                } else if (d6 > 2.0) {
                    d6 = 4.0;
                    this.dashPerBlock = 4;
                } else if (d6 > 1.0) {
                    d6 = 2.0;
                    this.dashPerBlock = 2;
                } else {
                    d10 -= 1.0;
                    d6 = 10.0;
                    this.dashPerBlock = 10;
                }
                this.step = 1.0 / this.norm * d6 * Math.pow(10.0, d10);
                d9 = (d2 - d3) / this.step;
                double d11 = this.horAxis ? Math.floor(1.0 * (double)rectangle.width / ((double)this.dashPerBlock * d9)) + 1.0 : Math.floor(1.0 * (double)rectangle.height / ((double)this.dashPerBlock * d9)) + 1.0;
                while (d11 <= 10.0) {
                    this.step *= 2.0;
                    d9 = (d2 - d3) / this.step;
                    double d12 = d11 = this.horAxis ? Math.floor(1.0 * (double)rectangle.width / ((double)this.dashPerBlock * d9)) + 1.0 : Math.floor(1.0 * (double)rectangle.height / ((double)this.dashPerBlock * d9)) + 1.0;
                }
            }
            d = Math.ceil(d3 / this.step) * this.step;
            DoublePoint doublePoint = this.horAxis ? new DoublePoint(d, this.minDpt.y) : new DoublePoint(this.minDpt.x, d);
            DoublePoint doublePoint2 = new DoublePoint(doublePoint);
            int n5 = 0;
            LinearScale linearScale = this;
            synchronized (linearScale) {
                while (rectangle.contains(this.getContext().lp2gpX(doublePoint2.x, doublePoint2.y), this.getContext().lp2gpY(doublePoint2.x, doublePoint2.y))) {
                    if (this.horAxis) {
                        doublePoint2.translate(-this.step / d6, 0.0);
                    } else {
                        doublePoint2.translate(0.0, -this.step / d6);
                    }
                    ++n5;
                }
                Object var31_32 = null;
            }
            if (this.horAxis) {
                doublePoint2.translate(this.step / d6, 0.0);
            } else {
                doublePoint2.translate(0.0, this.step / d6);
            }
            --n5;
            while ((double)n5 >= d6) {
                n5 = (int)((double)n5 - d6);
                d -= this.step;
            }
            boolean bl = true;
            int n6 = 0;
            boolean bl2 = rectangle.contains(this.getContext().lp2gpX(doublePoint2.x, doublePoint2.y), this.getContext().lp2gpY(doublePoint2.x, doublePoint2.y));
            while (bl2 || bl) {
                linearScaleDrawer.addDash(this.getContext().lp2gp(doublePoint2));
                if (this.horAxis) {
                    doublePoint2.translate(this.step / d6, 0.0);
                } else {
                    doublePoint2.translate(0.0, this.step / d6);
                }
                bl2 = rectangle.contains(this.getContext().lp2gpX(doublePoint2.x, doublePoint2.y), this.getContext().lp2gpY(doublePoint2.x, doublePoint2.y));
                if (bl2) {
                    bl = false;
                }
                if (!bl2 && n6++ > 20) break;
            }
            linearScaleDrawer.initSmallDashes = n5;
            linearScaleDrawer.minParam = d;
            linearScaleDrawer.dashesPerBlock = this.dashPerBlock;
            linearScaleDrawer.beginPoint = this.getContext().lp2gp(this.minDpt);
            linearScaleDrawer.endPoint = this.getContext().lp2gp(this.maxDpt);
            linearScaleDrawer.paramStep = this.step;
            linearScaleDrawer.norm = this.norm;
            linearScaleDrawer.textWidth = rectangle2.width;
            linearScaleDrawer.textHeight = rectangle2.height;
            return;
        }
        catch (Exception exception) {
            System.out.println("ups:" + exception);
            return;
        }
    }

    public DoublePoint getMaxPoint() {
        return new DoublePoint(this.maxDpt);
    }

    public void setMaxParam(double d) {
        super.setMaxParam(d);
        if (this.horAxis) {
            this.maxDpt.x = d;
            return;
        }
        this.maxDpt.y = d;
    }
}

