/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import physicon.graphLib2.LinearScaleDrawer;

public class LabeledLinearScaleDrawer
extends LinearScaleDrawer {
    private String label;
    private int labelInversion = -1;
    protected double alignment = 0.0;

    public LabeledLinearScaleDrawer(String string) {
        this.setLabel(string);
    }

    public LabeledLinearScaleDrawer(Color color, String string) {
        super(color);
        this.setLabel(string);
    }

    public LabeledLinearScaleDrawer(String string, Color color, int n) {
        super(color, n);
        this.setLabel(string);
    }

    public void drawLocal(Graphics graphics) {
        Point point;
        boolean bl;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl2 = bl = this.beginPoint.y == this.endPoint.y;
        if (bl) {
            this.arrowShiftX = fontMetrics.stringWidth(this.label) / 2 + 1;
            this.arrowShiftY = 10;
        } else {
            this.arrowShiftX = 10;
            this.arrowShiftY = fontMetrics.getMaxAscent() + 1;
        }
        super.drawLocal(graphics);
        double d = this.endPoint.x - this.beginPoint.x;
        double d2 = this.endPoint.y - this.beginPoint.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        double d5 = d2 / d3;
        int n = (int)Math.round((double)this.endPoint.x + (double)this.arrowShiftX * d4);
        int n2 = (int)Math.round((double)this.endPoint.y + (double)this.arrowShiftY * d5);
        Point point2 = new Point(n, n2);
        if (bl) {
            point2.translate((int)Math.round(10.0 * d4 / 2.0), 0);
        }
        if (bl) {
            point = this.labelInversion == 1 ? new Point((int)Math.round((this.alignment - 1.0) * (double)fontMetrics.stringWidth(this.label) / 2.0), this.labelInversion * (fontMetrics.getMaxAscent() + 3)) : new Point((int)Math.round((this.alignment - 1.0) * (double)fontMetrics.stringWidth(this.label) / 2.0), this.labelInversion * (fontMetrics.getMaxDescent() + 3));
        } else {
            point = new Point(-this.labelInversion * (fontMetrics.stringWidth(this.label) / 2 + 6), 0);
            point.translate((int)Math.round((this.alignment - 1.0) * (double)fontMetrics.stringWidth(this.label) / 2.0), 0);
        }
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setColor(this.getColor());
        graphics.translate(point2.x + point.x, point2.y + point.y);
        Font font2 = new Font("SansSerif", 2, 12);
        Font font3 = new Font("SansSerif", 0, 12);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this.label.length()) {
            String string;
            int n6;
            n4 = this.label.indexOf(59, n3 + 1);
            if (n4 < 0) {
                n4 = this.label.length();
            }
            if ((n6 = (string = this.label.substring(n3, n4)).indexOf(44)) < 0) {
                n6 = string.length();
            }
            graphics.setFont(font2);
            graphics.drawString(string.substring(0, n6), n5, 0);
            graphics.setFont(font3);
            graphics.drawString(string.substring(n6), n5 += fontMetrics.stringWidth(string.substring(0, n6)), 0);
            n5 += fontMetrics.stringWidth(string.substring(n6));
            n3 = n4;
        }
        graphics.translate(-(point2.x + point.x), -(point2.y + point.y));
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public void setAlignment(double d) {
        this.alignment = d;
    }

    public void invertLabel() {
        this.labelInversion *= -1;
    }

    public final String getLabel() {
        return new String(this.label);
    }

    public final void setLabel(String string) {
        this.label = string;
    }
}

