/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import physicon.funcs2.Func;
import physicon.graphLib2.CurveDrawerBase;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphCurveBase;

public class FuncCurve
extends GraphCurveBase {
    private Func func;
    private double minParamValue;
    private double maxParamValue;
    private double accuracy = 100.0;
    private double fixedParamStep = 0.0;

    public void setFixedParamStep(double d) {
        this.fixedParamStep = d;
        this.setRedrawFlag(true);
    }

    public void setFunc(Func func) {
        this.func = func;
        this.setRedrawFlag(true);
    }

    public Func getFunc() {
        return this.func;
    }

    public FuncCurve(CurveDrawerBase curveDrawerBase, Func func, double d, double d2) {
        super(curveDrawerBase);
        this.func = func;
        this.minParamValue = d;
        this.maxParamValue = d2;
    }

    public void setRedrawFlag(boolean bl) {
        super.setRedrawFlag(bl);
    }

    void spline(CurveDrawerBase curveDrawerBase, double d, double d2, double d3, double d4, int n) {
        curveDrawerBase.addPoint(this.getContext().lp2gp(this.getLocalPoint(d)));
        if (d2 - d < d4) {
            curveDrawerBase.addPoint(this.getContext().lp2gp(this.getLocalPoint(d2)));
            return;
        }
        int n2 = 2;
        double d5 = 0.967 * (d2 - d) / (double)n2;
        double d6 = (this.func.getValue(d) + this.func.getValue(d2)) * (d2 - d) / 2.0;
        double d7 = d;
        double d8 = 0.0;
        while (d7 < d2) {
            d8 += (this.func.getValue(d7) + this.func.getValue(d7 + d5)) * d5 / 2.0;
            d7 += d5;
        }
        if (Math.abs(d6 - (d8 += (this.func.getValue(d7 - d5) + this.func.getValue(d2)) * (d2 - d7 - d5) / 2.0)) > d3) {
            d5 = (d2 - d) / (double)n2;
            int n3 = 0;
            d7 = d;
            while (n3 < n2) {
                this.spline(curveDrawerBase, d7, d7 + d5, d3, d4, n);
                ++n3;
                d7 += d5;
            }
            return;
        }
        curveDrawerBase.addPoint(this.getContext().lp2gp(this.getLocalPoint(d2)));
    }

    public void setAccuracy(double d) {
        this.accuracy = d;
        this.setRedrawFlag(true);
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public final double getMinParamValue() {
        return this.minParamValue;
    }

    public double getMaxParamValue() {
        return this.maxParamValue;
    }

    public void setMinParamValue(double d) {
        this.minParamValue = d;
        this.setRedrawFlag(true);
    }

    public void setMaxParamValue(double d) {
        this.maxParamValue = d;
        this.setRedrawFlag(true);
    }

    public DoublePoint getLocalPoint(double d) {
        double d2 = d;
        if (d2 > this.maxParamValue) {
            d2 = this.maxParamValue;
        } else if (d2 < this.minParamValue) {
            d2 = this.minParamValue;
        }
        if (this.func.isDefinedAt(d2)) {
            return new DoublePoint(d2, this.func.getValue(d2));
        }
        return new DoublePoint(0.0, 0.0);
    }

    public void updateDrawer() {
        super.updateDrawer();
        GraphContextBase graphContextBase = this.getContext();
        CurveDrawerBase curveDrawerBase = (CurveDrawerBase)this.getDrawer();
        if (this.fixedParamStep == 0.0) {
            double d = graphContextBase.lpINgpX(new DoublePoint(0.0, 0.0));
            double d2 = graphContextBase.lpINgpY(new DoublePoint(0.0, 0.0));
            this.accuracy = 1.0;
            this.spline(curveDrawerBase, this.minParamValue, this.maxParamValue, this.accuracy * d * d2, d * 20.0, 100);
            return;
        }
        curveDrawerBase.reset();
        double d = this.minParamValue;
        while (d <= this.maxParamValue) {
            Point point = graphContextBase.lp2gp(this.getLocalPoint(d));
            if (!this.getFunc().isDefinedAt(d) || Math.abs(point.y) > 10000) {
                curveDrawerBase.addBreakPoint(point);
            } else {
                curveDrawerBase.addPoint(point);
            }
            d += this.fixedParamStep;
        }
    }
}

