/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import physicon.graphLib2.DrawerBase;

public class CurveHatchingDrawer
extends DrawerBase {
    private Color c;
    private Vector beginPoints;
    private Vector endPoints;

    public final Point beginPointAt(int n) {
        return (Point)this.beginPoints.elementAt(n);
    }

    public void reset() {
        this.beginPoints.removeAllElements();
        this.endPoints.removeAllElements();
    }

    public CurveHatchingDrawer(Color color) {
        this.c = color;
        this.beginPoints = new Vector();
        this.endPoints = new Vector();
    }

    public final Point endPointAt(int n) {
        return (Point)this.endPoints.elementAt(n);
    }

    public final Color getColor() {
        return this.c;
    }

    public void setColor(Color color) {
        this.c = color;
    }

    public void addLine(Point point, Point point2) {
        this.beginPoints.addElement(point);
        this.endPoints.addElement(point2);
    }

    public void drawLocal(Graphics graphics) {
        graphics.setColor(this.c);
        int n = this.beginPoints.size();
        int n2 = 0;
        while (n2 < n) {
            Point point = this.beginPointAt(n2);
            Point point2 = this.endPointAt(n2);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            ++n2;
        }
    }

    public Rectangle getLocalRoughRect() {
        int n = this.beginPoints.size();
        if (n == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Point point = this.beginPointAt(0);
        Point point2 = new Point(point.x, point.y);
        Point point3 = new Point(point.x, point.y);
        int n2 = 0;
        while (n2 < n) {
            Point point4 = this.beginPointAt(n2);
            if (point4.x < point2.x) {
                point2.x = point4.x;
            }
            if (point4.y < point2.y) {
                point2.y = point4.y;
            }
            if (point4.x > point3.x) {
                point3.x = point4.x;
            }
            if (point4.y > point3.y) {
                point3.y = point4.y;
            }
            point4 = this.endPointAt(n2);
            if (point4.x < point2.x) {
                point2.x = point4.x;
            }
            if (point4.y < point2.y) {
                point2.y = point4.y;
            }
            if (point4.x > point3.x) {
                point3.x = point4.x;
            }
            if (point4.y > point3.y) {
                point3.y = point4.y;
            }
            ++n2;
        }
        Rectangle rectangle = new Rectangle(point2.x, point2.y, point3.x - point2.x, point3.y - point2.y);
        rectangle.grow(1, 1);
        return rectangle;
    }
}

