/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import physicon.graphLib2.DrawerBase;
import physicon.graphLib2.GraphLibData;

public class CurveDrawerBase
extends DrawerBase {
    private Color c;
    private Vector points;
    private Vector breakPoints;
    protected boolean thick = false;

    public final void addPoint(Point point) {
        this.points.addElement(point);
    }

    public final void addBreakPoint(Point point) {
        Integer n = new Integer(this.pointsNumber());
        this.points.addElement(point);
        this.breakPoints.addElement(n);
    }

    public void reset() {
        super.reset();
        this.points.removeAllElements();
        this.breakPoints.removeAllElements();
    }

    public CurveDrawerBase(boolean bl) {
        this(GraphLibData.scaleColor, bl);
    }

    public CurveDrawerBase() {
        this(GraphLibData.scaleColor);
    }

    public CurveDrawerBase(Color color) {
        this(color, false);
    }

    public CurveDrawerBase(Color color, boolean bl) {
        this.c = color;
        this.points = new Vector();
        this.breakPoints = new Vector();
        this.thick = bl;
    }

    public final Color getColor() {
        return this.c;
    }

    public void setColor(Color color) {
        this.c = color;
    }

    public final Point pointAt(int n) {
        return (Point)this.points.elementAt(n);
    }

    public final int breakPointAt(int n) {
        return (Integer)this.breakPoints.elementAt(n);
    }

    public boolean contains(Point point) {
        Vector vector = (Vector)this.points.clone();
        int n = 0;
        while (n < vector.size() - 1) {
            int n2 = n + 1;
            while (n2 < vector.size()) {
                if (((Point)vector.elementAt((int)n)).x > ((Point)vector.elementAt((int)n2)).x) {
                    Object e = vector.elementAt(n);
                    vector.setElementAt(vector.elementAt(n2), n);
                    vector.setElementAt(e, n2);
                }
                ++n2;
            }
            ++n;
        }
        if (vector.size() > 0) {
            if (point.x < ((Point)vector.elementAt((int)0)).x) {
                return false;
            }
            if (point.x > ((Point)vector.elementAt((int)(vector.size() - 1))).x) {
                return false;
            }
        }
        n = 0;
        while (n < vector.size()) {
            Point point2 = (Point)vector.elementAt(n);
            if (point.x < point2.x) {
                double d;
                double d2;
                double d3;
                double d4;
                Point point3 = (Point)vector.elementAt(n == 0 ? 0 : n - 1);
                double d5 = point2.x;
                double d6 = point2.y;
                double d7 = point3.x;
                double d8 = point3.y;
                if (d5 == d7) {
                    d4 = Math.pow((double)point.x - d5, 2.0);
                } else {
                    d3 = (d6 - d8) / (d5 - d7);
                    d2 = d6 - d3 * d5;
                    d4 = Math.pow((double)point.y - d3 * (double)point.x - d2, 2.0) / (1.0 + d3 * d3);
                }
                d3 = Math.pow(d6 - (double)point.y, 2.0) + Math.pow(d5 - (double)point.x, 2.0);
                d2 = Math.pow(d8 - (double)point.y, 2.0) + Math.pow(d7 - (double)point.x, 2.0);
                double d9 = d4 <= d3 && d4 <= d2 ? d4 : (d = d3 <= d2 ? d3 : d2);
                return d < 5.0;
            }
            ++n;
        }
        return true;
    }

    public void drawLocal(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = n = this.breakPointsNumber() == 0 ? -1 : this.breakPointAt(n2);
        int n4 = this.points.size();
        graphics.setColor(this.getColor());
        int n5 = 1;
        while (n5 < n4) {
            if (n5 + 1 != n && n != -1 && n5 >= n) {
                n3 = n;
                n = this.breakPointsNumber() == ++n2 ? -1 : this.breakPointAt(n2);
            } else if (n5 - 1 != n3) {
                Point point = this.pointAt(n5 - 1);
                Point point2 = this.pointAt(n5);
                if (Math.abs(point.y) <= 10000 && Math.abs(point2.y) <= 10000) {
                    if (this.thick) {
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
                        graphics.drawLine(point.x - 1, point.y, point2.x - 1, point2.y);
                        graphics.drawLine(point.x, point.y - 1, point2.x, point2.y - 1);
                        graphics.drawLine(point.x, point.y + 1, point2.x, point2.y + 1);
                    } else {
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                    }
                }
            }
            ++n5;
        }
    }

    public final int pointsNumber() {
        return this.points.size();
    }

    public final int breakPointsNumber() {
        return this.breakPoints.size();
    }

    public Rectangle getLocalRoughRect() {
        int n = this.points.size();
        if (n == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Point point = this.pointAt(0);
        Point point2 = new Point(point.x, point.y);
        Point point3 = new Point(point.x, point.y);
        int n2 = 0;
        while (n2 < n) {
            Point point4 = this.pointAt(n2);
            if (point4.x < point2.x) {
                point2.x = point4.x;
            }
            if (point4.y < point2.y) {
                point2.y = point4.y;
            }
            if (point4.x > point3.x) {
                point3.x = point4.x;
            }
            if (point4.y > point3.y) {
                point3.y = point4.y;
            }
            ++n2;
        }
        Rectangle rectangle = new Rectangle(point2.x, point2.y, point3.x - point2.x, point3.y - point2.y);
        rectangle.grow(1, 1);
        return rectangle;
    }

    public void setThick(boolean bl) {
        this.thick = bl;
    }

    public final Vector getPoints() {
        return (Vector)this.points.clone();
    }
}

