/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Point;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.SequenceController;
import physicon.objava3.SimConfig;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;
import physicon.objava3.physics.WaveLengthCanvas;

public class WaveLengthControl
extends SimWindow
implements SequenceController {
    private WaveLengthCanvas control;
    CompositeTextBlock text;
    SimWindow output;
    private String m_eventChoiceName;
    private String m_eventSetName;

    public WaveLengthControl(SimWindow simWindow, Point point, Dimension dimension, int n, int n2, String string) {
        this(simWindow, point, dimension, n, n2, string, string == null ? null : string + "Set");
    }

    public WaveLengthControl(SimWindow simWindow, Point point, Dimension dimension, int n, int n2, String string, String string2) {
        this(simWindow, point, dimension, n, n2, string, string2, 40);
    }

    public WaveLengthControl(SimWindow simWindow, Point point, Dimension dimension, int n, int n2, String string, String string2, int n3) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        this.m_eventChoiceName = string;
        this.m_eventSetName = string2;
        this.output = new SimWindow(this, new Point(), new Dimension(n3, dimension.height));
        new ReliefDecoration(this.output);
        this.text = new CompositeTextBlock(this.output, new Point(5, dimension.height / 2), "\\italic{\\lambda} \\: =", CUtil.fString(n, 0), "nm", 33);
        this.control = new WaveLengthCanvas(this, new Point(n3 + 5, 0), new Dimension(dimension.width - (n3 + 5), dimension.height), n, n2){
            {
                WaveLengthControl.this.getClass();
            }

            public void notifyChange() {
                double d = this.getValue();
                WaveLengthControl.this.text.setString(CUtil.fString(d, 0));
                WaveLengthControl.this.output.paintAll();
                WaveLengthControl.this.output.flushBuffer();
                WaveLengthControl.this.notifyChange();
            }

            public void notifyLast() {
                WaveLengthControl.this.notifyLast();
            }
        };
    }

    public CompositeTextBlock getTextBlock() {
        return this.text;
    }

    public void notifyLast() {
        if (this.m_eventSetName != null) {
            this.publishEvent(this.m_eventSetName, new Integer(this.getCurrentValue()));
        }
    }

    public void notifyChange() {
        if (this.m_eventChoiceName != null) {
            this.publishEvent(this.m_eventChoiceName, new Integer(this.getCurrentValue()));
        }
    }

    public void setStringValue(String string) {
        this.setCurrentValue(new Integer(string));
        this.notifyChange();
        this.notifyLast();
    }

    public void setStep(int n) {
        this.control.setStep(n);
    }

    public int getStep() {
        return (int)this.control.getStep();
    }

    public String getStringValue() {
        return "" + this.getCurrentValue();
    }

    public void setCurrentValue(int n) {
        this.text.setString(CUtil.fString(n, 0));
        this.output.paintAll();
        this.output.flushBuffer();
        this.control.setValue(n);
    }

    public final int getCurrentValue() {
        return (int)this.control.getValue();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.control.setEnabled(bl);
    }
}

