/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Point;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.SequenceController;
import physicon.objava3.SimConfig;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;
import physicon.objava3.physics.ThermoCanvas;

public class ThermoControl
extends SimWindow
implements SequenceController {
    private ThermoCanvas control;
    CompositeTextBlock text;
    SimWindow output;
    int accuracy = 0;
    private String m_eventChoiceName;
    private String m_eventSetName;

    public CUtil.ScaleDrawer getScaleDrawer() {
        return this.control.getScaleDrawer();
    }

    public void setScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.control.setScaleDrawer(scaleDrawer);
    }

    public void setValue(double d) {
        this.text.setString(CUtil.fString(d, this.accuracy));
        this.output.paintAll();
        this.output.flushBuffer();
        this.control.setValue(d);
    }

    public double getValue() {
        return this.control.getValue();
    }

    public void setMinValue(double d) {
        this.control.setMinValue(d);
    }

    public double getMinValue() {
        return this.control.getMinValue();
    }

    public ThermoControl(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4, String string, String string2) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        this.m_eventChoiceName = string;
        this.m_eventSetName = string2;
        this.accuracy = CUtil.getNumberOfSignificantDigits(d4);
        this.output = new SimWindow(this, new Point(0, dimension.height - 25), new Dimension(dimension.width, 25));
        new ReliefDecoration(this.output);
        this.text = new CompositeTextBlock(this.output, new Point(5, 13), "\\italic{T \\: = \\:}", CUtil.fString(d, this.accuracy), "\\plain{K}", 33);
        this.control = new ThermoCanvas(this, new Point(), new Dimension(dimension.width, dimension.height - 25), d, d2, d3, d4){
            {
                ThermoControl.this.getClass();
            }

            public void notifyChange() {
                double d = this.getValue();
                ThermoControl.this.text.setString(CUtil.fString(d, ThermoControl.this.accuracy));
                ThermoControl.this.output.paintAll();
                ThermoControl.this.output.flushBuffer();
                ThermoControl.this.notifyChange();
            }

            public void notifyLast() {
                ThermoControl.this.notifyLast();
            }
        };
    }

    public CompositeTextBlock getTextBlock() {
        return this.text;
    }

    public void notifyLast() {
        if (this.m_eventSetName != null) {
            this.publishEvent(this.m_eventSetName, new Double(this.getValue()));
        }
    }

    public void notifyChange() {
        if (this.m_eventChoiceName != null) {
            this.publishEvent(this.m_eventChoiceName, new Double(this.getValue()));
        }
    }

    public void setMaxValue(double d) {
        this.control.setMaxValue(d);
    }

    public double getMaxValue() {
        return this.control.getMaxValue();
    }

    public void setStep(double d) {
        this.control.setStep(d);
    }

    public double getStep() {
        return this.control.getStep();
    }

    public void setStringValue(String string) {
        this.setValue(new Double(string));
        this.control.notifyChange();
        this.control.notifyLast();
    }

    public String getStringValue() {
        return "" + this.getValue();
    }

    public int getSpace() {
        return this.control.getSpace();
    }

    public void setSpace(int n) {
        this.control.setSpace(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.control.setEnabled(bl);
    }
}

