/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.objava3.physics.MainColorData;

public class Spectrum {
    static final int MIN_WL = 380;
    static final int MAX_WL = 760;
    static final int MAIN_COLORS_NUM = 10;
    private static MainColorData[] mcData = new MainColorData[]{new MainColorData(0, 0, 0, 360), new MainColorData(255, 0, 255, 400), new MainColorData(0, 0, 255, 436), new MainColorData(0, 255, 255, 485), new MainColorData(0, 255, 0, 540), new MainColorData(255, 255, 0, 590), new MainColorData(255, 255, 0, 595), new MainColorData(255, 0, 0, 625), new MainColorData(255, 0, 0, 670), new MainColorData(0, 0, 0, 820)};
    private static int nMainColors = 10;
    private static int minWL = 380;
    private static int maxWL = 760;

    public static void drawHorz(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        while (n < rectangle.x + rectangle.width) {
            float f = (float)(bl ? n - rectangle.x : rectangle.x + rectangle.width - 1 - n) * (float)(maxWL - minWL) / (float)(rectangle.width - 1) + (float)minWL;
            graphics.setColor(Spectrum.colorFromWave(Math.round(f)));
            graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            ++n;
        }
    }

    protected Spectrum() {
    }

    public static Color colorFromWave(int n) {
        if (n < Spectrum.mcData[0].m_wl || n > Spectrum.mcData[Spectrum.nMainColors - 1].m_wl) {
            return Color.black;
        }
        int n2 = 1;
        while (n > Spectrum.mcData[n2].m_wl) {
            ++n2;
        }
        float f = Spectrum.mcData[n2 - 1].m_wl;
        float f2 = (float)Spectrum.mcData[n2].m_wl - f;
        return new Color(Math.round(((float)n - f) / f2 * (float)(Spectrum.mcData[n2].m_red - Spectrum.mcData[n2 - 1].m_red)) + Spectrum.mcData[n2 - 1].m_red, Math.round(((float)n - f) / f2 * (float)(Spectrum.mcData[n2].m_green - Spectrum.mcData[n2 - 1].m_green)) + Spectrum.mcData[n2 - 1].m_green, Math.round(((float)n - f) / f2 * (float)(Spectrum.mcData[n2].m_blue - Spectrum.mcData[n2 - 1].m_blue)) + Spectrum.mcData[n2 - 1].m_blue);
    }

    public static void drawVert(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n = rectangle.y;
        while (n < rectangle.y + rectangle.height) {
            float f = (float)(bl ? n - rectangle.y : rectangle.y + rectangle.height - 1 - n) * (float)(maxWL - minWL) / (float)(rectangle.height - 1) + (float)minWL;
            graphics.setColor(Spectrum.colorFromWave(Math.round(f)));
            graphics.drawLine(rectangle.y, n, rectangle.y + rectangle.height, n);
            ++n;
        }
    }
}

