/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import physicon.objava3.SimObject;
import physicon.objava3.more.ColorDecorationBase;

public class PolylineDecoration
extends ColorDecorationBase {
    protected Polygon m_poly;
    private boolean decorationClosed;

    public PolylineDecoration(SimObject simObject, Point point, int[] nArray, int[] nArray2, int n, Color color) {
        this(simObject, point, nArray, nArray2, n, color, true);
    }

    public PolylineDecoration(SimObject simObject, Point point, int[] nArray, int[] nArray2, int n, Color color, boolean bl) {
        super(simObject, point, color);
        this.setDecorationClosed(bl);
        if (n > 0) {
            this.m_poly = new Polygon(nArray, nArray2, n);
            return;
        }
        this.m_poly = new Polygon();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getColor());
        if (this.getPointsNum() >= 2) {
            if (this.isDecorationClosed()) {
                graphics.drawPolygon(this.m_poly);
                return;
            }
            int n = 0;
            while (n < this.getPointsNum() - 1) {
                graphics.drawLine(this.m_poly.xpoints[n], this.m_poly.ypoints[n], this.m_poly.xpoints[n + 1], this.m_poly.ypoints[n + 1]);
                ++n;
            }
            return;
        }
        if (this.getPointsNum() == 1) {
            int n = this.m_poly.xpoints[0];
            int n2 = this.m_poly.ypoints[0];
            graphics.drawLine(n, n2, n, n2 + 1);
        }
    }

    public Point pointAt(int n) throws IndexOutOfBoundsException {
        return new Point(this.m_poly.xpoints[n], this.m_poly.ypoints[n]);
    }

    public void add(int n, int n2) {
        this.m_poly.addPoint(n, n2);
    }

    public void setDecorationClosed(boolean bl) {
        this.decorationClosed = bl;
    }

    public boolean isDecorationClosed() {
        return this.decorationClosed;
    }

    public int getPointsNum() {
        return this.m_poly.npoints;
    }

    public Rectangle getRoughRect() {
        return this.m_poly.getBounds();
    }

    public void flush() {
        this.m_poly = new Polygon();
    }
}

