/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Point;
import physicon.objava3.more.PointConvertor;

public class CircularPointConvertor
implements PointConvertor {
    private double m_minR;
    private double m_maxR;

    public final double getMaxRadius() {
        return this.m_maxR;
    }

    public void setMaxRadius(double d) {
        this.m_maxR = d;
    }

    public Point convertPoint(Point point) {
        int n = point.x;
        int n2 = point.y;
        double d = Math.sqrt(n * n + n2 * n2);
        if (d > this.m_maxR) {
            double d2 = Math.atan2(n2, n);
            n = (int)Math.round(this.m_maxR * Math.cos(d2));
            n2 = (int)Math.round(this.m_maxR * Math.sin(d2));
        } else if (d < this.m_minR) {
            double d3 = Math.atan2(n2, n);
            n = (int)Math.round(this.m_minR * Math.cos(d3));
            n2 = (int)Math.round(this.m_minR * Math.sin(d3));
        }
        return new Point(n, n2);
    }

    public CircularPointConvertor(double d, double d2) {
        this.m_minR = d;
        this.m_maxR = d2;
    }

    public final double getMinRadius() {
        return this.m_minR;
    }

    public void setMinRadius(double d) {
        this.m_minR = d;
    }
}

