/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.graph;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.GraphEngine.GEObject;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.graphLib2.GraphLibData;
import physicon.objava3.Region;
import physicon.objava3.SimObject;

public class SimGraphElement
extends Region
implements GraphElementInterface {
    private GraphElementBase element;

    public SimGraphElement(SimObject simObject, GraphElementBase graphElementBase) {
        super(simObject, new Point(0, 0));
        this.element = graphElementBase;
    }

    public void updateRefPoint() {
        Point point = this.element.getGEObject().getGlobalRefPoint();
        super.setRefPoint(point.x, point.y);
    }

    public void paint(Graphics graphics) {
        GEObject gEObject = this.element.getGEObject();
        if (gEObject != GraphLibData.nullDrawer) {
            gEObject.drawLocal(graphics);
            this.element.setRedrawFlag(false);
        }
    }

    public boolean contains(int n, int n2) {
        return this.element.getDrawer().contains(new Point(n, n2));
    }

    public Rectangle getRoughRect() {
        return this.element.getGEObject().getLocalRoughRect();
    }

    public final GraphElementBase getGraphElement() {
        return this.element;
    }

    public void setRefPoint(int n, int n2) {
        super.setRefPoint(n, n2);
        GraphContextBase graphContextBase = this.element.getContext();
        graphContextBase.setOffset(new Point(0, 0));
        this.element.setRefPoint(graphContextBase.gp2lp(new Point(n, n2)));
    }

    public void setRefPoint(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.element.getContext();
        graphContextBase.setOffset(new Point(0, 0));
        this.element.setRefPoint(doublePoint);
        Point point = graphContextBase.lp2gp(doublePoint);
        super.setRefPoint(point.x, point.y);
    }
}

