/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.ParseException;
import java.util.Hashtable;
import physicon.controls.ResConstants;
import physicon.controls.SkinLoader;
import physicon.metatex3.Block;
import physicon.metatex3.FontBlock;
import physicon.metatex3.MetaTexProperties;
import physicon.metatex3.Parser;
import physicon.objava3.SimConfig;
import physicon.objava3.SimObject;
import physicon.objava3.TextRegion;

public class SimMetaTeXBlock
extends TextRegion {
    private Dimension m_size = new Dimension();
    private Parser m_parser;
    private Image m_image = null;
    private String m_text = null;
    protected Block m_block = new Block();

    public int getAscent() {
        return this.m_block.getShiftedAscent();
    }

    public int getDescent() {
        return this.getHeight() - this.getAscent();
    }

    public void drawContent(Graphics graphics) {
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, this);
        }
    }

    public SimMetaTeXBlock(SimObject simObject, Point point, String string, int n, int n2) {
        super(simObject, point, string, n2);
        String string2 = ResConstants.texfont + (n > 0 ? "+" : "") + n + ".res";
        Hashtable hashtable = SkinLoader.getMetaProperties(string2);
        this.m_parser = new Parser(hashtable, null);
        this.setString(string);
    }

    public SimMetaTeXBlock(SimObject simObject, Point point, String string, int n) {
        this(simObject, point, string, 0, n);
    }

    public SimMetaTeXBlock(SimObject simObject, Point point, String string) {
        this(simObject, point, string, 0);
    }

    public void setString(String string) {
        if (string.equals(this.m_text)) {
            return;
        }
        this.m_text = string;
        super.setString(this.m_text);
        try {
            this.m_block = this.m_parser.parse(this.m_text);
            FontBlock fontBlock = (FontBlock)this.m_block.getBlockByName("color");
            Color color = SimConfig.OUTPUT_FONT_COLOR;
            Parser.setDefaultColor(color);
            Color color2 = this.getSimWindow().getBkgColor();
            if (fontBlock == null || fontBlock.getColor() == null) {
                color = Parser.getDefaultColor();
                if (color.equals(color2)) {
                    color = color2.equals(Color.black) ? Color.white : Color.black;
                }
            } else {
                color = fontBlock.getColor();
            }
            Parser.setDefaultColor(color);
            color = new Color(color.getRed() > 127 ? 0.0f : 1.0f, (float)Math.random(), (float)Math.random());
            this.m_block.setBackground(color);
            this.m_size = this.m_block.getSize();
            this.m_image = this.m_size.width > 0 && this.m_size.height > 0 ? this.m_parser.createBlockImage(this.m_block) : null;
            return;
        }
        catch (ParseException parseException) {
            try {
                this.m_block = this.m_parser.parse("parse \\: error");
                this.m_block.setBackground(this.getSimWindow().getBkgColor());
                this.m_size = this.m_block.getSize();
                this.m_image = this.m_parser.createBlockImage(this.m_block);
                return;
            }
            catch (ParseException parseException2) {
                this.m_image = null;
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.m_image != null) {
            this.m_image.flush();
            this.m_image = null;
        }
    }

    public MetaTexProperties getProperties() {
        return this.m_parser.getProperties();
    }

    public int getHeight() {
        return this.m_block.getHeight();
    }

    public int getWidth() {
        return this.m_block.getWidth();
    }
}

