/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import physicon.objava3.EventPublisher;
import physicon.objava3.EventSubscriber;
import physicon.objava3.RSRTransitions;

public class RSRSwitch {
    public static final String evtRun = "evtRun";
    public static final String evtStop = "evtStop";
    public static final String evtReset = "evtReset";
    public static final String evtEnd = "evtEnd";
    private RSRTransitions m_trans;
    private EventPublisher m_ep;
    private int m_mode = 3;

    public RSRSwitch(RSRTransitions rSRTransitions, EventPublisher eventPublisher) {
        this.m_trans = rSRTransitions;
        this.m_ep = eventPublisher;
        this.m_ep.addSubscriber(evtRun, new EventSubscriber(){

            public void receiveEvent(Object object) {
                RSRSwitch.this.onRun();
            }
            {
                RSRSwitch.this.getClass();
            }
        });
        this.m_ep.addSubscriber(evtStop, new EventSubscriber(){

            public void receiveEvent(Object object) {
                RSRSwitch.this.onStop();
            }
            {
                RSRSwitch.this.getClass();
            }
        });
        this.m_ep.addSubscriber(evtReset, new EventSubscriber(){

            public void receiveEvent(Object object) {
                RSRSwitch.this.onReset();
            }
            {
                RSRSwitch.this.getClass();
            }
        });
        this.m_ep.addSubscriber(evtEnd, new EventSubscriber(){

            public void receiveEvent(Object object) {
                RSRSwitch.this.onEnd();
            }
            {
                RSRSwitch.this.getClass();
            }
        });
    }

    public final int getMode() {
        return this.m_mode;
    }

    void onStop() {
        if (this.m_mode != 1) {
            return;
        }
        this.m_trans.runToStop();
        this.m_trans.onModeChange(2);
        this.m_mode = 2;
    }

    void onRun() {
        switch (this.m_mode) {
            case 2: {
                this.m_trans.stopToRun();
                break;
            }
            case 3: {
                this.m_trans.resetToRun();
                break;
            }
            case 4: {
                this.m_trans.endToRun();
                break;
            }
            default: {
                return;
            }
        }
        this.m_trans.onModeChange(1);
        this.m_mode = 1;
    }

    void onReset() {
        switch (this.m_mode) {
            case 1: {
                this.m_trans.runToReset();
                break;
            }
            case 2: {
                this.m_trans.stopToReset();
                break;
            }
            case 4: {
                this.m_trans.endToReset();
                break;
            }
            default: {
                return;
            }
        }
        this.m_trans.onModeChange(3);
        this.m_mode = 3;
    }

    void onEnd() {
        if (this.m_mode != 1) {
            return;
        }
        this.m_trans.runToEnd();
        this.m_trans.onModeChange(4);
        this.m_mode = 4;
    }
}

