/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.ParseException;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.FontCache;
import physicon.metatex3.MetaTexFont;
import physicon.metatex3.MetaTexProperties;
import physicon.metatex3.Parser;

public class TextBlock
extends Block {
    private String text;
    private double space;
    private Image image;
    private int yoffset;
    private int height;
    private boolean createdAsNative;
    private TextBlock[] charBlocks;
    private Point[] charCoords;

    public boolean isText() {
        return this.text != null || "longminus".equals(this.name);
    }

    public String getText() {
        return this.text;
    }

    public boolean testArgs(Vector vector) {
        return vector.size() == 1;
    }

    protected void setBorders() {
        this.rtext = true;
        this.ltext = true;
    }

    TextBlock() {
        this.name = null;
        this.text = null;
        this.space = 0.0;
    }

    public TextBlock(double d) {
        this();
        this.space = d;
    }

    public TextBlock(String string) {
        this();
        this.name = string;
    }

    public TextBlock(char c) throws ParseException {
        this();
        this.text = "" + c;
    }

    public TextBlock(MetaTexProperties metaTexProperties, char c) throws ParseException {
        this(c);
        this.setProperties(metaTexProperties);
        if (FontCache.getCharMetric(this.getFont(), String.valueOf(c)) == null) {
            throw new ParseException("symbol '" + this.text + "' is not supported by parser", -1);
        }
    }

    public TextBlock(MetaTexProperties metaTexProperties) {
        this();
        this.setProperties(metaTexProperties);
    }

    public TextBlock(MetaTexProperties metaTexProperties, double d) {
        this(d);
        this.setProperties(metaTexProperties);
    }

    public TextBlock(MetaTexProperties metaTexProperties, String string) {
        this(string);
        this.setProperties(metaTexProperties);
    }

    public void setArgs(Vector vector) {
        this.text = (String)vector.elementAt(0);
        int n = 0;
        while (n < this.text.length()) {
            char c = this.text.charAt(n);
            if (c != ' ' && FontCache.getCharMetric(this.getFont(), String.valueOf(c)) == null) {
                throw new RuntimeException("Character '" + this.text.charAt(n) + "' is not supported");
            }
            ++n;
        }
        this.createdAsNative = true;
    }

    public void sizeSelf() {
        if (this.createdAsNative) {
            int n;
            this.charBlocks = new TextBlock[this.text.length()];
            this.charCoords = new Point[this.text.length()];
            int n2 = 0;
            while (n2 < this.text.length()) {
                try {
                    n = this.text.charAt(n2);
                    this.charBlocks[n2] = n == 32 ? new TextBlock(this.props, 0.5) : new TextBlock(this.props, (char)n);
                    this.charCoords[n2] = new Point();
                    this.charBlocks[n2].setInternalStyle(this.style);
                    this.charBlocks[n2].setScale(this.scale);
                    this.charBlocks[n2].getSize();
                }
                catch (ParseException parseException) {}
                ++n2;
            }
            this.descent = 0;
            this.ascent = 0;
            n2 = 0;
            while (n2 < this.charBlocks.length) {
                this.ascent = Math.max(this.ascent, this.charBlocks[n2].ascent);
                this.descent = Math.max(this.descent, this.charBlocks[n2].descent);
                ++n2;
            }
            n2 = 0;
            n = 0;
            int n3 = 0;
            while (n3 < this.charBlocks.length) {
                if (n3 > 0) {
                    n2 += this.charBlocks[n3 - 1].rspace + this.charBlocks[n3].lspace;
                }
                this.charCoords[n3].x = n2;
                this.charCoords[n3].y = this.ascent - this.charBlocks[n3].ascent;
                if ((n2 += this.charBlocks[n3].width) > n) {
                    n = n2;
                }
                ++n3;
            }
            this.width = n;
            if (this.charBlocks.length > 0) {
                this.lspace = this.charBlocks[0].lspace;
                this.rspace = this.charBlocks[this.charBlocks.length - 1].rspace;
                return;
            }
        } else {
            MetaTexFont metaTexFont = this.getFont();
            int[] nArray = metaTexFont.getFontMetric();
            int n = nArray[2] - metaTexFont.getSize() / 2;
            boolean bl = true;
            if (this.name == null && this.text == null) {
                nArray = metaTexFont.getSpaceMetric();
                this.width = (int)((double)nArray[0] * this.space + 0.5);
                this.height = nArray[1];
                this.ascent = nArray[2] - n;
                this.descent = nArray[3] + n;
                this.rspace = 0;
                this.lspace = 0;
                this.yoffset = nArray[6];
                return;
            }
            if (this.name != null) {
                nArray = FontCache.getExtraMetric(metaTexFont, this.name);
                if (nArray == null) {
                    bl = false;
                    nArray = FontCache.getSymbolMetric(metaTexFont, this.name);
                }
            } else {
                nArray = FontCache.getCharMetric(metaTexFont, this.text);
            }
            if (nArray != null) {
                this.image = this.name != null ? (bl ? FontCache.getExtraImage(metaTexFont, this.name) : FontCache.getSymbolImage(metaTexFont, this.name)) : FontCache.getCharImage(metaTexFont, this.text);
            } else {
                nArray = metaTexFont.getFontMetric();
            }
            this.width = nArray[0];
            this.height = nArray[1];
            this.ascent = nArray[2] - n;
            this.descent = nArray[3] + n;
            this.lspace = nArray[4];
            this.rspace = nArray[5];
            this.yoffset = nArray[6];
        }
    }

    public String toString() {
        return "TextBlock[" + (this.name != null ? this.name : (this.text != null ? this.text + "" : "" + this.space)) + "]";
    }

    public int getArgType(int n) {
        if (n < 1) {
            return 0;
        }
        return -1;
    }

    private Image getColorImage(Color color) {
        return Parser.filterImage(this.image, this.width, this.height, this.background, color);
    }

    public void paintSelf(Graphics graphics) {
        if (this.createdAsNative) {
            int n = 0;
            while (n < this.charBlocks.length) {
                Point point = this.charCoords[n];
                graphics.translate(point.x, point.y);
                this.charBlocks[n].paint(graphics);
                graphics.translate(-point.x, -point.y);
                ++n;
            }
            return;
        }
        if (this.image != null) {
            graphics.drawImage(this.getColorImage(graphics.getColor()), 0, this.yoffset, null);
            return;
        }
        if (this.name != null || this.text != null) {
            graphics.drawRect(2, 2, this.width - 4, this.getHeight() - 4);
        }
    }

    protected void setSpaces() {
    }

    public double getSpace() {
        return this.space;
    }

    public static String toMeta(char c) {
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '_') {
            return "\\_";
        }
        if (c == '^') {
            return "\\^";
        }
        if (c == '{') {
            return "\\{";
        }
        if (c == '}') {
            return "\\}";
        }
        if (c == ' ') {
            return "\\:";
        }
        return String.valueOf(c);
    }

    public boolean isCreatedAsNative() {
        return this.createdAsNative;
    }

    public void setInternalStyle(int n) {
        this.style = n;
    }
}

