/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.MetaTexFont;
import physicon.metatex3.MetaTexGraphics;
import physicon.metatex3.TagParser;

public class OverBlock
extends Block
implements TagParser {
    public static final int UNKNOWN = 0;
    public static final int LEFTARROW = 1;
    public static final int RIGHTARROW = 2;
    public static final int TILDE = 3;
    public static final int SINGLELINE = 4;
    public static final int DOUBLELINE = 5;
    public static final int LEFTRIGHTARROW = 6;
    public static final int CDOT = 7;
    public static final int DCDOT = 8;
    public static final int TCDOT = 9;
    private static String HANDLED_TAG = "over";
    private int symType;
    private int symw;
    private int symhh;
    private int r;

    public boolean testArgs(Vector vector) {
        return vector.size() == 2;
    }

    public Block parseTag(String string) {
        if (string.equals("over")) {
            return new OverBlock();
        }
        throw new IllegalArgumentException("tag " + string + " is not supported by " + this.getClass().getName());
    }

    public OverBlock() {
        super(2);
    }

    public void setArgs(Vector vector) {
        String string = ((String)vector.elementAt(0)).trim();
        this.symType = 0;
        if (string.equals("rightarrow")) {
            this.symType = 2;
        } else if (string.equals("leftarrow")) {
            this.symType = 1;
        } else if (string.equals("leftrightarrow")) {
            this.symType = 6;
        } else if (string.equals("tilde")) {
            this.symType = 3;
        } else if (string.equals("cdot") || string.equals("dot")) {
            this.symType = 7;
        } else if (string.equals("dcdot")) {
            this.symType = 8;
        } else if (string.equals("tcdot")) {
            this.symType = 9;
        }
        this.blocks[0] = (Block)vector.elementAt(1);
    }

    public void sizeSelf() {
        if (this.symType == 3) {
            int n = 3;
            this.width = Math.max(12, this.blocks[0].width + 2 * n);
            this.r = 1 + (int)((double)this.width / (2.0 * Math.sqrt(2.0)));
            int n2 = this.r - (int)((double)this.r * Math.sqrt(2.0)) / 2;
            this.coords[0].x = n;
            this.coords[0].y = 2 * n2 + 1;
            this.ascent = this.blocks[0].ascent + 2 * n2 + 1;
            this.descent = this.blocks[0].descent;
        } else {
            MetaTexFont metaTexFont = this.getFont();
            int[] nArray = metaTexFont.getSpaceMetric();
            this.symw = this.symType == 7 || this.symType == 8 || this.symType == 9 ? 0 : Math.max(3, nArray[0] / 2);
            this.symhh = Math.max(2, nArray[1] / 4);
            this.ascent = 2 * this.symhh + this.blocks[0].ascent + 1;
            this.descent = this.blocks[0].descent;
            this.width = this.blocks[0].width + 2 * this.symw;
            this.coords[0].x = this.symw;
            this.coords[0].y = 2 * this.symhh + 1;
        }
        this.lspace = this.blocks[0].lspace;
        this.rspace = this.blocks[0].rspace;
        this.ltext = this.blocks[0].ltext;
        this.rtext = this.blocks[0].rtext;
    }

    public int getArgType(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 2) {
            return 1;
        }
        return -1;
    }

    private void drawDot(Graphics graphics) {
        graphics.drawOval((this.width - 2) / 2, 3, 2, 2);
        graphics.drawLine(this.width / 2, 4, this.width / 2, 4);
    }

    public String[] getHandledTags() {
        return new String[]{HANDLED_TAG};
    }

    public void paintSelf(Graphics graphics) {
        switch (this.symType) {
            case 2: {
                graphics.drawLine(1, this.symhh + 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(this.width - 1 - this.symw, 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(this.width - 1 - this.symw, 2 * this.symhh + 2, this.width - 1, this.symhh + 2);
                return;
            }
            case 1: {
                graphics.drawLine(1, this.symhh + 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(1, this.symhh + 2, 1 + this.symw, 2);
                graphics.drawLine(1, this.symhh + 2, 1 + this.symw, 2 * this.symhh + 2);
                return;
            }
            case 6: {
                graphics.drawLine(1, this.symhh + 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(this.width - 1 - this.symw, 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(this.width - 1 - this.symw, 2 * this.symhh + 2, this.width - 1, this.symhh + 2);
                graphics.drawLine(1, this.symhh + 2, 1 + this.symw, 2);
                graphics.drawLine(1, this.symhh + 2, 1 + this.symw, 2 * this.symhh + 2);
                return;
            }
            case 4: {
                graphics.drawLine(1, this.symhh + 2, this.width - 1, this.symhh + 2);
                return;
            }
            case 7: {
                this.drawDot(graphics);
                return;
            }
            case 8: {
                graphics.translate(-2, 0);
                this.drawDot(graphics);
                graphics.translate(4, 0);
                this.drawDot(graphics);
                graphics.translate(-2, 0);
                return;
            }
            case 9: {
                graphics.translate(-4, 0);
                this.drawDot(graphics);
                graphics.translate(8, 0);
                this.drawDot(graphics);
                graphics.translate(-4, 0);
                this.drawDot(graphics);
                return;
            }
            case 3: {
                MetaTexGraphics metaTexGraphics = new MetaTexGraphics(graphics);
                metaTexGraphics.drawQuaver2(2, 2, 0, this.r);
                int n = this.r - metaTexGraphics.getQuaverWidth();
                int n2 = metaTexGraphics.getQuaverWidth();
                metaTexGraphics.drawQuaver2(1, n, 0, this.r);
                metaTexGraphics.drawQuaver2(3, 2 * n, n2, this.r);
                metaTexGraphics.drawQuaver2(4, 3 * n - 1, n2, this.r);
            }
        }
    }

    public int getSymbolType() {
        return this.symType;
    }
}

