/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphCurveBase;
import physicon.graphLib2.GraphMarkerBase;
import physicon.graphLib2.MarkerDrawerBase;

public class PointMarker
extends GraphMarkerBase {
    private double param;
    private GraphCurveBase curve;
    private DoublePoint location;

    public void setLocation(double d, double d2) {
        this.setLocation(new DoublePoint(d, d2));
    }

    public DoublePoint getLocation() {
        return this.location;
    }

    public PointMarker(MarkerDrawerBase markerDrawerBase) {
        super(markerDrawerBase);
        this.curve = null;
        this.param = 0.0;
        this.setLocation(new DoublePoint());
    }

    public PointMarker(MarkerDrawerBase markerDrawerBase, GraphCurveBase graphCurveBase) {
        super(markerDrawerBase);
        this.curve = graphCurveBase;
        this.param = this.curve.getMinParamValue();
        this.setLocation(this.curve.getGlobalPoint(this.param));
    }

    public void setParamValue(double d) {
        if (this.curve != null) {
            this.param = d;
            if (this.param < this.curve.getMinParamValue()) {
                this.param = this.curve.getMinParamValue();
            }
            if (this.param > this.curve.getMaxParamValue()) {
                this.param = this.curve.getMaxParamValue();
            }
            this.setLocation(this.curve.getGlobalPoint(this.param));
        }
    }

    public double getParamValue() {
        return this.param;
    }

    public void setCurve(GraphCurveBase graphCurveBase) {
        this.curve = graphCurveBase;
        this.param = this.location.x;
        this.setLocation(this.curve.getGlobalPoint(this.param));
    }

    public void setLocation(DoublePoint doublePoint) {
        this.location = doublePoint;
        this.setRefPoint(this.location);
        this.setRedrawFlag(true);
    }
}

