/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import physicon.graphLib2.GraphLibData;
import physicon.graphLib2.LinearScaleDrawer;
import physicon.graphLib2.MetaTeXBlock;

public class MetaTeXLinearScaleDrawer
extends LinearScaleDrawer {
    private String prefix = "\\color{white}{";
    private String postfix = "}";
    protected int labelInversion;
    protected double alignment;
    protected MetaTeXBlock formula = null;
    protected int hsh = 0;
    protected int vsh = 0;

    public MetaTeXLinearScaleDrawer(String string) {
        this(GraphLibData.scaleColor, string);
    }

    public MetaTeXLinearScaleDrawer(Color color, String string) {
        this(color, string, "graph.txt");
    }

    public MetaTeXLinearScaleDrawer(Color color, String string, String string2) {
        super(color);
        this.formula = new MetaTeXBlock(this.prefix + string + this.postfix, string2);
        this.labelInversion = -1;
        this.alignment = 0.0;
    }

    public void setHor(int n) {
        this.hsh = n;
    }

    public void drawLocal(Graphics graphics) {
        Point point;
        boolean bl;
        Dimension dimension = this.formula.getSize();
        boolean bl2 = bl = this.beginPoint.y == this.endPoint.y;
        if (bl) {
            this.arrowShiftX = 10;
            this.arrowShiftY = 10;
        } else {
            this.arrowShiftX = 10;
            this.arrowShiftY = 10;
        }
        super.drawLocal(graphics);
        double d = this.endPoint.x - this.beginPoint.x;
        double d2 = this.endPoint.y - this.beginPoint.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        double d5 = d2 / d3;
        int n = (int)Math.round((double)this.endPoint.x + (double)this.arrowShiftX * d4);
        int n2 = (int)Math.round((double)this.endPoint.y + (double)this.arrowShiftY * d5);
        Point point2 = new Point(n, n2);
        if (bl) {
            point2.translate((int)Math.round(10.0 * d4 / 2.0), 0);
        } else {
            point2.translate(0, (int)Math.round(10.0 * d5 / 2.0));
        }
        if (bl) {
            point = new Point(0, this.vsh - this.labelInversion * (dimension.height / 2 + 3));
            point.translate(-dimension.width / 2 + (int)(this.alignment * (double)dimension.width / 2.0), -dimension.height / 2);
        } else {
            point = new Point(this.hsh - this.labelInversion * (dimension.width / 2 + 6), 0);
            point.translate(-dimension.width / 2, -dimension.height / 2 + (int)(this.alignment * (double)dimension.height / 2.0));
        }
        point2.translate(point.x, point.y);
        this.formula.setLocation(point2.x, point2.y);
        this.formula.paint(graphics);
    }

    public void setAlignment(int n) {
        this.setAlignment((double)n);
    }

    public void setAlignment(double d) {
        this.alignment = d;
    }

    public void invertLabel() {
        this.labelInversion *= -1;
    }

    public final String getLabel() {
        return new String(this.formula.getText());
    }

    public final void setLabel(String string) {
        this.formula.setText(this.prefix + string + this.postfix);
    }

    public void setVert(int n) {
        this.vsh = n;
    }
}

