/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.GraphLibData;
import physicon.graphLib2.ScaleDrawerBase;

public class LinearScaleDrawer
extends ScaleDrawerBase {
    public Point beginPoint = null;
    public Point endPoint = null;
    public double paramStep = 0.0;
    public double norm = 0.0;
    public int dashesPerBlock = 0;
    public int initSmallDashes = 0;
    public int textHeight;
    public int textWidth;
    public int arrowShiftX = 10;
    public int arrowShiftY = 10;
    protected int inversion = 1;
    protected boolean showZero = true;
    protected Font font;
    protected int adjustment = 0;
    protected boolean showDashes = true;
    protected boolean labelsOnly = false;
    protected boolean oneSideStyle = false;
    private boolean enlargedCentralDash = true;
    private boolean dashesLabeled = true;

    public boolean isEnlargedCentralDash() {
        return this.enlargedCentralDash;
    }

    public void reset() {
        super.reset();
        this.beginPoint = null;
        this.endPoint = null;
        this.paramStep = 0.0;
        this.norm = 0.0;
        this.dashesPerBlock = 0;
        this.initSmallDashes = 0;
        this.textHeight = 0;
        this.textWidth = 0;
    }

    public void setDashesLabeled(boolean bl) {
        this.dashesLabeled = bl;
    }

    public LinearScaleDrawer() {
        this(GraphLibData.scaleColor, 10);
    }

    public LinearScaleDrawer(Color color) {
        this(color, 10);
    }

    public LinearScaleDrawer(Color color, int n) {
        super(color);
        if (n != 0) {
            this.font = new Font("Serif", 0, n);
        }
    }

    public boolean isDashesLabeled() {
        return this.dashesLabeled;
    }

    public void setOneSideStyle(boolean bl) {
        this.oneSideStyle = bl;
    }

    public void setAdjustment(int n) {
        this.adjustment = n;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public final Font getFont() {
        return this.font;
    }

    public void drawLocal(Graphics graphics) {
        boolean bl;
        if (this.beginPoint.x != this.endPoint.x && this.beginPoint.y != this.endPoint.y) {
            System.out.println("Warning!!! You are attempting to draw");
            System.out.println("oblique linear scale.");
            System.out.println("The library may not work properly");
        }
        Font font = null;
        if (this.font != null) {
            font = graphics.getFont();
            graphics.setFont(this.font);
        }
        Color color = graphics.getColor();
        graphics.setColor(this.getColor());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl2 = bl = this.beginPoint.y == this.endPoint.y;
        if (this.initSmallDashes < 0) {
            this.initSmallDashes = this.dashesPerBlock + this.initSmallDashes;
            this.minParam += this.paramStep;
        }
        double d = this.minParam;
        graphics.drawLine(this.beginPoint.x, this.beginPoint.y, this.endPoint.x, this.endPoint.y);
        if (this.showDashes) {
            int n;
            int n2;
            int n3 = this.dashesNumber();
            int n4 = 0;
            if (!this.labelsOnly) {
                while (n4 < n3 && n4 < this.initSmallDashes) {
                    n2 = this.getDash((int)n4).x;
                    n = this.getDash((int)n4).y;
                    if (bl) {
                        if (!this.oneSideStyle) {
                            graphics.drawLine(n2, n - GraphLibData.smallDashLen, n2, n + GraphLibData.smallDashLen);
                        } else {
                            graphics.drawLine(n2, n, n2, n + this.inversion * GraphLibData.smallDashLen);
                        }
                    } else if (!this.oneSideStyle) {
                        graphics.drawLine(n2 - GraphLibData.smallDashLen, n, n2 + GraphLibData.smallDashLen, n);
                    } else {
                        graphics.drawLine(n2, n, n2 + this.inversion * GraphLibData.smallDashLen, n);
                    }
                    ++n4;
                }
            }
            n2 = !(this.norm <= 1.0) ? 0 : 1;
            block1: while (n4 < n3) {
                Point point;
                String string;
                n = this.getDash((int)n4).x;
                int n5 = this.getDash((int)n4).y;
                d = (double)Math.round(d * this.norm) / this.norm;
                String string2 = string = n2 != 0 ? String.valueOf(Math.round(d)) : String.valueOf(d);
                if (bl) {
                    point = new Point(-fontMetrics.stringWidth(string) / 2, this.inversion > 0 ? GraphLibData.largeDashLen + fontMetrics.getAscent() : -GraphLibData.largeDashLen - 2);
                    if (!this.labelsOnly) {
                        if (!this.oneSideStyle) {
                            graphics.drawLine(n, n5 - GraphLibData.largeDashLen, n, n5 + GraphLibData.largeDashLen);
                        } else {
                            graphics.drawLine(n, n5, n, n5 + this.inversion * GraphLibData.largeDashLen);
                        }
                        if (d == 0.0) {
                            point.x -= fontMetrics.stringWidth(string) / 2 + GraphLibData.largeDashLen;
                        }
                    }
                    if (this.isDashesLabeled() && (this.showZero || d != 0.0)) {
                        graphics.drawString(string, n + point.x + this.adjustment, n5 + point.y);
                    }
                } else {
                    point = new Point(this.inversion > 0 ? -(fontMetrics.stringWidth(string) + GraphLibData.largeDashLen + 2) : GraphLibData.largeDashLen + 2, fontMetrics.getAscent() / 2);
                    if (!this.labelsOnly) {
                        if (!this.oneSideStyle) {
                            graphics.drawLine(n - GraphLibData.largeDashLen, n5, n + GraphLibData.largeDashLen, n5);
                        } else {
                            graphics.drawLine(n, n5, n - this.inversion * GraphLibData.largeDashLen, n5);
                        }
                    }
                    if (this.isDashesLabeled() && (this.showZero || d != 0.0)) {
                        graphics.drawString(string, n + point.x, n5 + point.y + this.adjustment);
                    }
                }
                d += this.paramStep;
                ++n4;
                int n6 = 1;
                while (n6 < this.dashesPerBlock) {
                    if (n4 >= n3) continue block1;
                    n = this.getDash((int)n4).x;
                    n5 = this.getDash((int)n4).y;
                    if (!this.labelsOnly) {
                        int n7;
                        int n8 = n7 = this.isEnlargedCentralDash() && this.dashesPerBlock % 2 == 0 && n6 == this.dashesPerBlock / 2 ? GraphLibData.middleDashLen : GraphLibData.smallDashLen;
                        if (bl) {
                            if (!this.oneSideStyle) {
                                graphics.drawLine(n, n5 - n7, n, n5 + n7);
                            } else {
                                graphics.drawLine(n, n5, n, n5 + this.inversion * n7);
                            }
                        } else if (!this.oneSideStyle) {
                            graphics.drawLine(n - n7, n5, n + n7, n5);
                        } else {
                            graphics.drawLine(n, n5, n - this.inversion * n7, n5);
                        }
                    }
                    ++n4;
                    ++n6;
                }
            }
        }
        double d2 = this.endPoint.x - this.beginPoint.x;
        double d3 = this.endPoint.y - this.beginPoint.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d2 / d4;
        double d6 = d3 / d4;
        int n = (int)Math.round((double)this.endPoint.x + (double)this.arrowShiftX * d5);
        int n9 = (int)Math.round((double)this.endPoint.y + (double)this.arrowShiftY * d6);
        int[] nArray = new int[]{(int)Math.round((double)n - 3.0 * d6), (int)Math.round((double)n + 10.0 * d5), (int)Math.round((double)n + 3.0 * d6)};
        int[] nArray2 = new int[]{(int)Math.round((double)n9 - 3.0 * d5), (int)Math.round((double)n9 + 10.0 * d6), (int)Math.round((double)n9 + 3.0 * d5)};
        graphics.drawLine(this.endPoint.x, this.endPoint.y, n, n9);
        graphics.fillPolygon(nArray, nArray2, 3);
        if (this.font != null) {
            graphics.setFont(font);
        }
        graphics.setColor(color);
    }

    public void showZero(boolean bl) {
        this.showZero = bl;
    }

    public void setLabelsOnlyStyle(boolean bl) {
        this.labelsOnly = bl;
    }

    public final void showDashes(boolean bl) {
        this.showDashes = bl;
    }

    public Rectangle getLocalRoughRect() {
        boolean bl = this.beginPoint.y == this.endPoint.y;
        Rectangle rectangle = bl ? new Rectangle(this.beginPoint.x, this.beginPoint.y - GraphLibData.largeDashLen, this.endPoint.x - this.beginPoint.x, GraphLibData.largeDashLen * 2) : new Rectangle(this.beginPoint.x - GraphLibData.largeDashLen, this.beginPoint.y, GraphLibData.largeDashLen * 2, this.endPoint.y - this.beginPoint.y);
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        if (bl) {
            rectangle.width += this.arrowShiftX + 10;
            if (this.beginPoint.x > this.endPoint.x) {
                rectangle.x -= this.arrowShiftX + 10;
            }
            rectangle.height += this.textHeight;
            if (this.inversion < 0) {
                rectangle.y -= this.textHeight;
            }
        } else {
            rectangle.height += this.arrowShiftY + 10;
            if (this.beginPoint.y > this.endPoint.y) {
                rectangle.y -= this.arrowShiftY + 10;
            }
            rectangle.width += this.textWidth;
            if (this.inversion > 0) {
                rectangle.x -= this.textWidth;
            }
        }
        rectangle.grow(1, 1);
        return rectangle;
    }

    public void setEnlargedCentralDash(boolean bl) {
        this.enlargedCentralDash = bl;
    }

    public void invertText() {
        this.inversion *= -1;
    }
}

