/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.ChartDrawerBase;
import physicon.graphLib2.MetaTeXBlock;

public class LinHorChartDrawer
extends ChartDrawerBase {
    Color dashColor;
    private int dashes;
    private int space;
    private MetaTeXBlock label = null;

    public LinHorChartDrawer(Color color, Color color2, int n, String string) {
        super(color);
        this.dashColor = color2;
        this.space = 3;
        int n2 = this.dashes = n != 0 ? n : 1;
        if (string != null) {
            this.label = new MetaTeXBlock(string, "graph.txt");
        }
    }

    public void drawLocal(Graphics graphics) {
        graphics.setColor(this.dashColor);
        double d = (double)this.width / (double)this.dashes;
        int n = 0;
        while (n < this.dashes + 1) {
            graphics.drawLine(this.x + (int)Math.round((double)n * d), this.y, this.x + (int)Math.round((double)n * d), this.y + this.height);
            ++n;
        }
        graphics.drawLine(this.x, this.y, this.x + this.width, this.y);
        graphics.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
        graphics.setColor(this.getColor());
        if (this.maxValue != 0.0) {
            n = this.width >= 0 ? this.x : this.x + (int)Math.round((double)this.width * this.curValue / this.maxValue);
            int n2 = this.height >= 0 ? this.y : this.y + this.height;
            int n3 = this.width >= 0 ? this.width : -this.width;
            int n4 = this.height >= 0 ? this.height : -this.height;
            graphics.setColor(Color.black);
            graphics.fillRect(n, (n2 += this.space) + 1, (int)Math.round((double)n3 * this.curValue / this.maxValue), (n4 -= this.space * 2) - 1);
            graphics.setColor(this.getColor());
            graphics.fillRect(n + 1, n2 + 2, (int)Math.round((double)n3 * this.curValue / this.maxValue) - 2, n4 - 3);
            graphics.setColor(this.dashColor);
            graphics.drawLine(n, n2, n, n2 + n4);
        } else {
            System.out.println("Warning!!! maxValue = 0.");
        }
        this.getLocalRoughRect();
        if (this.label != null) {
            this.label.setLocation(this.x + this.width + this.space, this.y + (this.height - this.label.getHeight()) / 2);
            this.label.paint(graphics);
        }
    }

    public Rectangle getLocalRoughRect() {
        int n = this.width >= 0 ? this.x : this.x - this.width;
        int n2 = this.height >= 0 ? this.y : this.y - this.height;
        int n3 = this.width >= 0 ? this.width : -this.width;
        int n4 = this.height >= 0 ? this.height : -this.height;
        return new Rectangle(n, n2, n3, n4);
    }
}

