/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import physicon.GraphEngine.GEObject;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContainerBase;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.graphLib2.LinearScale;

public class ComponentGraphContainer
extends GraphContainerBase
implements Runnable {
    private Component component;
    private Rectangle componentRect;
    private Rectangle invalidRect;
    private Rectangle elementClipRect;
    Vector elements;
    Thread thread = null;
    private Color bgColor = null;

    public synchronized void setElementClipRect(Rectangle rectangle) {
        this.elementClipRect = new Rectangle(rectangle);
    }

    public final void showElement(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfElement(graphElementInterface) == -1) {
            System.out.print("Warning!!! You are attempting ");
            System.out.print("to show or hide the element ");
            System.out.println("that is not in GraphContainer");
            return;
        }
        if (bl) {
            this.addGraphElement(graphElementInterface.getGraphElement());
            return;
        }
        this.removeGraphElement(graphElementInterface.getGraphElement());
    }

    void removeGraphElement(GraphElementBase graphElementBase) {
        this.elements.removeElement(graphElementBase);
    }

    public synchronized void invalidate(GraphElementBase graphElementBase) {
        graphElementBase.updateDrawer();
        GEObject gEObject = graphElementBase.getGEObject();
        Rectangle rectangle = gEObject.getLocalRoughRect();
        Point point = gEObject.getGlobalRefPoint();
        rectangle.x += point.x;
        rectangle.y += point.y;
        if (this.invalidRect == null) {
            this.invalidRect = rectangle;
            return;
        }
        this.invalidRect = this.invalidRect.union(rectangle);
    }

    public synchronized void invalidate() {
        int n = this.elements.size();
        int n2 = 0;
        while (n2 < n) {
            GraphElementBase graphElementBase = (GraphElementBase)this.elements.elementAt(n2);
            if (graphElementBase.getRedrawFlag()) {
                if (!graphElementBase.isVisible()) {
                    graphElementBase.setRedrawFlag(false);
                } else {
                    GEObject gEObject = graphElementBase.getGEObject();
                    Rectangle rectangle = gEObject.getLocalRoughRect();
                    Point point = gEObject.getGlobalRefPoint();
                    rectangle.x += point.x;
                    rectangle.y += point.y;
                    this.invalidRect = this.invalidRect == null ? rectangle : this.invalidRect.union(rectangle);
                }
            }
            ++n2;
        }
    }

    public void setMouseLabel(String string, int n, int n2) {
        if (string != null && !string.equals("")) {
            Graphics graphics = this.component.getGraphics();
            graphics.setClip(this.componentRect);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getHeight();
            graphics.setColor(this.bgColor == null ? this.component.getBackground() : this.bgColor);
            graphics.fillRect(n + 2, n2 - 2 - n4, n3, n4);
            graphics.setColor(Color.gray);
            graphics.drawString(string, n + 2, n2 - 3);
        }
    }

    public ComponentGraphContainer(GraphContextBase graphContextBase, Component component, int n, int n2, int n3, int n4) {
        super(graphContextBase);
        this.component = component;
        this.componentRect = new Rectangle(n - 10, n2, n3 + 10, n4);
        this.elementClipRect = null;
        this.elements = new Vector();
    }

    void addGraphElement(GraphElementBase graphElementBase) {
        graphElementBase.setVisible(true);
        if (this.elements.indexOf(graphElementBase) != -1) {
            return;
        }
        int n = this.elements.size();
        double d = graphElementBase.getGEObject().getGlobalLevel();
        int n2 = 0;
        while (n2 < n) {
            GraphElementBase graphElementBase2 = (GraphElementBase)this.elements.elementAt(n2);
            GEObject gEObject = graphElementBase2.getGEObject();
            if (gEObject.getGlobalLevel() > d) break;
            ++n2;
        }
        this.elements.insertElementAt(graphElementBase, n2);
    }

    public synchronized void startGE() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.invalidateAll();
        this.thread.start();
    }

    public synchronized void stopGE() {
        if (this.thread == null) {
            return;
        }
        this.thread.stop();
        this.thread = null;
    }

    public void drawGhostLine(Point point, Point point2, Rectangle rectangle) {
        if (point.equals(point2)) {
            return;
        }
        Graphics graphics = this.component.getGraphics();
        graphics.setClip(rectangle);
        graphics.setColor(Color.gray);
        if (point.x == point2.x) {
            point.y = this.componentRect.y;
            point2.y = point.y + this.componentRect.height;
        } else if (point.y == point2.y) {
            point.x = this.componentRect.x;
            point2.x = point.x + this.componentRect.width;
        } else {
            double d = (double)(point2.y - point.y) / (double)(point2.x - point.x);
            point.y += (int)Math.round(d * (double)(this.componentRect.x - point.x));
            point.x = this.componentRect.x;
            point2.y += (int)Math.round(d * (double)(this.componentRect.x + this.componentRect.width - point2.x));
            point2.x = point.x + this.componentRect.width;
        }
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public final void showScale(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfScale(graphElementInterface) == -1) {
            System.out.print("Warning!!! You are attempting ");
            System.out.print("to show or hide the scale ");
            System.out.println("that is not in GraphContainer");
            return;
        }
        if (bl) {
            this.addGraphElement(graphElementInterface.getGraphElement());
            return;
        }
        this.removeGraphElement(graphElementInterface.getGraphElement());
    }

    public synchronized boolean contains(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.getContext();
        graphContextBase.setOffset(new Point(0, 0));
        return this.componentRect.contains(graphContextBase.lp2gpX(doublePoint.x, doublePoint.y), graphContextBase.lp2gpY(doublePoint.x, doublePoint.y));
    }

    public GraphElementBase elementAt(Point point) {
        int n = this.elements.size() - 1;
        while (n >= 0) {
            try {
                GraphElementBase graphElementBase = (GraphElementBase)this.elements.elementAt(n);
                if (!Class.forName("physicon.graphLib2.LinearGrid").isAssignableFrom(graphElementBase.getClass()) && !Class.forName("physicon.graphLib2.LinearScale").isAssignableFrom(graphElementBase.getClass()) && graphElementBase.contains(point)) {
                    return (GraphElementBase)this.elements.elementAt(n);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            --n;
        }
        return null;
    }

    public GraphElementBase elementAt(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.getContext();
        graphContextBase.setOffset(new Point(0, 0));
        return this.elementAt(graphContextBase.lp2gp(doublePoint));
    }

    public Component getComponent() {
        return this.component;
    }

    public final void setBgColor(Color color) {
        this.bgColor = color;
    }

    public void invalidateAll() {
        super.invalidateAll();
        this.invalidRect = new Rectangle(new Point(0, 0), this.component.getSize());
        this.paintComponent(this.component.getGraphics());
    }

    public void invalidateAll(Graphics graphics) {
        super.invalidateAll();
        this.invalidRect = new Rectangle(new Point(0, 0), this.component.getSize());
        this.paintComponent(graphics);
    }

    public boolean isInContainer(GraphElementBase graphElementBase) {
        int n = 0;
        while (n < this.elements.size()) {
            if (this.elements.elementAt(n).equals(graphElementBase)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.invalidRect != null) continue;
        }
    }

    public Vector allElementsAt(Point point) {
        Vector<GraphElementBase> vector = new Vector<GraphElementBase>();
        int n = this.elements.size() - 1;
        while (n >= 0) {
            try {
                GraphElementBase graphElementBase = (GraphElementBase)this.elements.elementAt(n);
                if (graphElementBase.contains(point) && !Class.forName("physicon.graphLib2.LinearGrid").isAssignableFrom(graphElementBase.getClass()) && !Class.forName("physicon.graphLib2.LinearScale").isAssignableFrom(graphElementBase.getClass())) {
                    vector.addElement((GraphElementBase)this.elements.elementAt(n));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            --n;
        }
        return vector;
    }

    public Vector allElementsAt(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.getContext();
        graphContextBase.setOffset(new Point(0, 0));
        return this.allElementsAt(graphContextBase.lp2gp(doublePoint));
    }

    public synchronized void paintComponent(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.elements;
        synchronized (vector2) {
            vector = (Vector)this.elements.clone();
            Object var13_4 = null;
        }
        int n = vector.size();
        if (this.invalidRect == null) {
            return;
        }
        if (!this.invalidRect.intersects(this.componentRect)) {
            return;
        }
        this.invalidRect = this.invalidRect.intersection(this.componentRect);
        Image image = this.component.createImage(this.invalidRect.width, this.invalidRect.height);
        Graphics graphics2 = image.getGraphics();
        graphics2.translate(-this.invalidRect.x, -this.invalidRect.y);
        if (this.bgColor != null) {
            graphics2.setColor(this.bgColor);
            graphics2.fillRect(this.componentRect.x, this.componentRect.y, this.componentRect.width, this.componentRect.height);
        }
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Rectangle rectangle;
                Point point;
                GEObject gEObject;
                block12: {
                    GraphElementBase graphElementBase = (GraphElementBase)vector.elementAt(n2);
                    graphElementBase.setRedrawFlag(false);
                    if (!graphElementBase.isVisible()) break block11;
                    graphElementBase.updateDrawer();
                    gEObject = graphElementBase.getGEObject();
                    Rectangle rectangle2 = gEObject.getLocalRoughRect();
                    point = gEObject.getGlobalRefPoint();
                    rectangle2.x += point.x;
                    rectangle2.y += point.y;
                    if (!this.invalidRect.intersects(rectangle2)) break block11;
                    rectangle = this.invalidRect.intersection(rectangle2);
                    if (this.elementClipRect == null || graphElementBase instanceof LinearScale) break block12;
                    if (!rectangle.intersects(this.elementClipRect)) break block11;
                    rectangle = rectangle.intersection(this.elementClipRect);
                }
                if (!rectangle.isEmpty()) {
                    graphics2.translate(point.x, point.y);
                    gEObject.drawLocal(graphics2);
                    graphics2.translate(-point.x, -point.y);
                }
            }
            ++n2;
        }
        graphics.drawImage(image, this.invalidRect.x, this.invalidRect.y, this.component);
        graphics2.translate(this.invalidRect.x, this.invalidRect.y);
        this.invalidRect = null;
    }
}

