/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls.mart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import physicon.controls.CUtil;
import physicon.controls.IComponent;
import physicon.controls.ISlider;
import physicon.controls.Image1x1;
import physicon.controls.mart.SliderCanvas;

public class SSlider
extends SliderCanvas
implements ISlider {
    private boolean paintTicks = true;
    Component m_comp;
    private static final int smallDashSize = 1;
    private static final int largeDashSize = 3;
    private Image m_ebar = new Image1x1("eslidebar.gif");
    private Image m_dbar = new Image1x1("dslidebar.gif");
    private Image m_eline = new Image1x1("eslideline.gif");
    private Image m_dline = new Image1x1("dslideline.gif");
    private Dimension m_barSize = new Dimension(this.m_ebar.getWidth(this), this.m_ebar.getHeight(this));
    private Rectangle m_ruler;
    private double m_distance;
    private int m_accuracy;
    private int m_dashes;
    private String[] m_label;
    Image m_buffer;

    public boolean isPaintTicks() {
        return this.paintTicks;
    }

    public void setRange(double d, double d2) {
        this.internalSetMin(d);
        this.internalSetMax(d2);
    }

    public void setSkin(Image image, Image image2, Image image3, Image image4) {
        this.m_ebar = image;
        this.m_dbar = image2;
        this.m_eline = image3;
        this.m_dline = image4;
        this.m_barSize = new Dimension(this.m_ebar.getWidth(this), this.m_ebar.getHeight(this));
        this.setMetrics();
    }

    public void paint(Graphics graphics) {
        if (this.m_buffer == null) {
            this.dispatchEvent(new ComponentEvent(this, 101));
        }
        Graphics graphics2 = this.m_buffer.getGraphics();
        this.drawRuler(graphics2);
        this.drawThumb(graphics2);
        graphics.drawImage(this.m_buffer, 0, 0, this);
    }

    public Component getAWTComponent() {
        return this;
    }

    public SSlider(double d, double d2, double d3, double d4, int n, String[] stringArray) {
        super(d2, d3, d, d4, n);
        this.m_ruler = new Rectangle(this.m_barSize.width / 2, 0, this.getSize().width - this.m_barSize.width - 1, 4);
        this.m_comp = this;
        this.m_accuracy = n;
        this.setDashes((d3 - d2) / 2.0, 2);
        this.setLabels(stringArray);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SSlider.this.m_buffer = SSlider.this.m_comp.createImage(SSlider.this.getSize().width, SSlider.this.getSize().height);
                SSlider.this.setMetrics();
            }
            {
                SSlider.this.getClass();
            }
        });
    }

    private void drawThumb(Graphics graphics) {
        Image image;
        Image image2 = image = this.isEnabled() ? this.m_ebar : this.m_dbar;
        if (image == null) {
            return;
        }
        CUtil.drawImage(graphics, image, this.getThumbPosition() - this.m_barSize.width / 2, 0, null, this);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setMetrics();
    }

    public void setComponent(Component component) {
        this.m_comp = component;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setLabels(String[] stringArray) {
        if (stringArray == null) {
            int n = (int)Math.round((this.getMaxValue() - this.getMinValue()) / this.m_distance) + 1;
            this.m_label = new String[n];
            int n2 = 0;
            while (n2 < this.m_label.length) {
                this.m_label[n2] = CUtil.fString(this.getMinValue() + (double)n2 * this.m_distance, this.m_accuracy);
                ++n2;
            }
        } else {
            this.m_label = stringArray;
        }
        this.setMetrics();
    }

    public String[] getLabels() {
        return this.m_label;
    }

    public void setPaintTicks(boolean bl) {
        this.paintTicks = bl;
        this.repaint();
    }

    public void setDashes(double d, int n) {
        this.m_distance = d;
        this.m_dashes = n;
        this.setLabels(null);
    }

    private void drawRuler(Graphics graphics) {
        Image image;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Image image2 = image = this.isEnabled() ? this.m_eline : this.m_dline;
        if (image != null) {
            this.m_ruler.height = image.getHeight(this);
            CUtil.drawImage(graphics, image, this.m_ruler.x, this.m_ruler.y, this.m_ruler.width, this.m_ruler.height, null, this);
        }
        if (!this.isPaintTicks()) {
            return;
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        double d = this.getMinValue();
        int n = 0;
        while (d <= this.getMaxValue()) {
            int n2 = this.valueToPix(d);
            int n3 = this.m_barSize.height - 1;
            int n4 = 1;
            if (n % this.m_dashes == 0) {
                n4 = 3;
                int n5 = n / this.m_dashes;
                if (n5 < this.m_label.length) {
                    if (this.isEnabled()) {
                        CUtil.drawText(graphics, this.m_label[n5], n2, n3 + n4, 12);
                    } else {
                        CUtil.drawDisabledText(graphics, this.m_label[n5], n2, n3 + n4, 12);
                    }
                }
            }
            if (this.isEnabled()) {
                graphics.drawLine(n2, n3, n2, n3 + n4);
            } else {
                graphics.setColor(SystemColor.textHighlightText);
                graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1 + n4);
                graphics.setColor(SystemColor.textInactiveText);
                graphics.drawLine(n2, n3, n2, n3 + n4);
            }
            d = this.getMinValue() + (double)(++n) * this.m_distance / (double)this.m_dashes;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.repaint();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_buffer == null) {
            return;
        }
        this.m_buffer.flush();
        if (!IComponent.isMicrosoft) {
            return;
        }
        this.m_buffer = null;
        System.gc();
    }

    void setMetrics() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = 0;
        int n2 = 0;
        if (this.getLabels().length > 0) {
            n = fontMetrics.stringWidth(this.getLabels()[0]) / 2;
            n2 = fontMetrics.stringWidth(this.getLabels()[this.getLabels().length - 1]) / 2;
        }
        this.setMinShift(Math.max(n, this.m_barSize.width / 2) + 1);
        this.setMaxShift(Math.max(n2, this.m_barSize.width / 2) + 1);
        this.m_ruler.x = this.getMinShift();
        this.m_ruler.width = this.getRange();
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

