/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import physicon.controls.CUtil;
import physicon.controls.IButton;
import physicon.controls.ICheckbox;
import physicon.controls.IComponent;
import physicon.controls.IFactory;
import physicon.controls.ISlider;
import physicon.controls.ResConstants;
import physicon.controls.SkinLoader;
import physicon.controls.mart.CBGroup;

public abstract class AbstractFactory
extends ResConstants
implements IFactory {
    public abstract IButton createButton(String var1);

    public abstract ISlider createSlider(double var1, double var3, double var5, double var7, int var9, String[] var10);

    public abstract ICheckbox createToggleButton(String var1, boolean var2, CBGroup var3);

    protected IComponent getControl(String string, Class[] classArray, Object[] objectArray) {
        IComponent iComponent = null;
        try {
            Class<?> clazz = Class.forName("physicon.controls.mart." + string);
            iComponent = (IComponent)clazz.getConstructor(classArray).newInstance(objectArray);
            iComponent.validate();
            Object[] objectArray2 = ResConstants.fontForName(SkinLoader.get(string, ResConstants.controlFont));
            iComponent.setFont((Font)objectArray2[0]);
            iComponent.setForeground((Color)objectArray2[1]);
            iComponent.setBackground(ResConstants.colorForName(SkinLoader.get(string, ResConstants.panelColor)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iComponent;
    }

    public void setSkin(String string) {
        SkinLoader.loadSkin(string);
        CUtil.hostColor = this.getHostColor();
    }

    public abstract void drawRelief(Graphics var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public Object[] getPictureFont() {
        return ResConstants.fontForName(SkinLoader.get(ResConstants.pictureFont));
    }

    public Object[] getOutputFont() {
        return ResConstants.fontForName(SkinLoader.get(ResConstants.outputFont));
    }

    public void setHostColor(Color color) {
        CUtil.hostColor = color;
    }

    public Color getHostColor() {
        return ResConstants.colorForName(SkinLoader.get(ResConstants.hostColor));
    }

    public Color getPanelColor() {
        return ResConstants.colorForName(SkinLoader.get(ResConstants.panelColor));
    }

    static {
        SkinLoader.loadSkin(SkinLoader.get(ResConstants.zipFileName));
    }

    public String getSkinName() {
        return SkinLoader.currentSkin();
    }

    public Object[] getControlFont() {
        return ResConstants.fontForName(SkinLoader.get(ResConstants.controlFont));
    }

    public Object[] getAxisFont() {
        return ResConstants.fontForName(SkinLoader.get(ResConstants.axisFont));
    }

    public abstract ICheckbox createCheckbox();

    public abstract ICheckbox createCheckbox(String var1);

    public abstract ICheckbox createCheckbox(String var1, boolean var2);

    public abstract ICheckbox createCheckbox(String var1, boolean var2, CBGroup var3);

    public abstract ICheckbox createCheckbox(String var1, CBGroup var2, boolean var3);

    public abstract IButton createButton();
}

